/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapper.primitive;

import cool.scx.object.mapper.FromNodeContext;
import cool.scx.object.mapper.NodeMapper;
import cool.scx.object.mapper.NodeMappingException;
import cool.scx.object.mapper.ToNodeContext;
import cool.scx.object.node.IntNode;
import cool.scx.object.node.Node;
import cool.scx.object.node.ValueNode;

public final class ShortNodeMapper
implements NodeMapper<Short> {
    private final boolean isPrimitive;

    public ShortNodeMapper(boolean isPrimitive) {
        this.isPrimitive = isPrimitive;
    }

    @Override
    public Node toNode(Short value, ToNodeContext context) {
        return new IntNode(value.shortValue());
    }

    @Override
    public Short fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        if (node.isNull()) {
            return this.isPrimitive ? Short.valueOf((short)0) : null;
        }
        if (node instanceof ValueNode) {
            ValueNode valueNode = (ValueNode)node;
            try {
                return (short)valueNode.asInt();
            }
            catch (NumberFormatException e) {
                throw new NodeMappingException(e);
            }
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }
}

