/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapper.primitive_array;

import cool.scx.object.mapper.FromNodeContext;
import cool.scx.object.mapper.NodeMapper;
import cool.scx.object.mapper.NodeMappingException;
import cool.scx.object.mapper.ToNodeContext;
import cool.scx.object.node.ArrayNode;
import cool.scx.object.node.BooleanNode;
import cool.scx.object.node.Node;
import cool.scx.object.node.ValueNode;

public final class BooleanArrayNodeMapper
implements NodeMapper<boolean[]> {
    @Override
    public Node toNode(boolean[] value, ToNodeContext context) {
        ArrayNode arrayNode = new ArrayNode(value.length);
        for (boolean i : value) {
            arrayNode.add(BooleanNode.of(i));
        }
        return arrayNode;
    }

    @Override
    public boolean[] fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        if (node.isNull()) {
            return null;
        }
        if (node instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)node;
            boolean[] result = new boolean[arrayNode.size()];
            int i = 0;
            for (Node e : arrayNode) {
                result[i] = this.toBoolean(e);
                ++i;
            }
            return result;
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }

    private boolean toBoolean(Node element) throws NodeMappingException {
        if (element.isNull()) {
            throw new NodeMappingException("Element cannot be null");
        }
        if (element instanceof ValueNode) {
            ValueNode valueNode = (ValueNode)element;
            return valueNode.asBoolean();
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(element.getClass()));
    }
}

