/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapper.primitive_array;

import cool.scx.object.mapper.FromNodeContext;
import cool.scx.object.mapper.NodeMapper;
import cool.scx.object.mapper.NodeMappingException;
import cool.scx.object.mapper.ToNodeContext;
import cool.scx.object.node.ArrayNode;
import cool.scx.object.node.DoubleNode;
import cool.scx.object.node.Node;
import cool.scx.object.node.ValueNode;

public final class DoubleArrayNodeMapper
implements NodeMapper<double[]> {
    @Override
    public Node toNode(double[] value, ToNodeContext context) {
        ArrayNode arrayNode = new ArrayNode(value.length);
        for (double i : value) {
            arrayNode.add(new DoubleNode(i));
        }
        return arrayNode;
    }

    @Override
    public double[] fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        if (node.isNull()) {
            return null;
        }
        if (node instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)node;
            double[] result = new double[arrayNode.size()];
            int i = 0;
            for (Node e : arrayNode) {
                result[i] = this.toDouble(e);
                ++i;
            }
            return result;
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }

    private double toDouble(Node element) throws NodeMappingException {
        if (element.isNull()) {
            throw new NodeMappingException("Element cannot be null");
        }
        if (element instanceof ValueNode) {
            ValueNode valueNode = (ValueNode)element;
            try {
                return valueNode.asDouble();
            }
            catch (NumberFormatException e) {
                throw new NodeMappingException(e);
            }
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(element.getClass()));
    }
}

