/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapper.primitive_array;

import cool.scx.object.mapper.FromNodeContext;
import cool.scx.object.mapper.NodeMapper;
import cool.scx.object.mapper.NodeMappingException;
import cool.scx.object.mapper.ToNodeContext;
import cool.scx.object.node.ArrayNode;
import cool.scx.object.node.FloatNode;
import cool.scx.object.node.Node;
import cool.scx.object.node.ValueNode;

public final class FloatArrayNodeMapper
implements NodeMapper<float[]> {
    @Override
    public Node toNode(float[] value, ToNodeContext context) {
        ArrayNode arrayNode = new ArrayNode(value.length);
        for (float i : value) {
            arrayNode.add(new FloatNode(i));
        }
        return arrayNode;
    }

    @Override
    public float[] fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        if (node.isNull()) {
            return null;
        }
        if (node instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)node;
            float[] result = new float[arrayNode.size()];
            int i = 0;
            for (Node e : arrayNode) {
                result[i] = this.toFloat(e);
                ++i;
            }
            return result;
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }

    private float toFloat(Node element) throws NodeMappingException {
        if (element.isNull()) {
            throw new NodeMappingException("Element cannot be null");
        }
        if (element instanceof ValueNode) {
            ValueNode valueNode = (ValueNode)element;
            try {
                return valueNode.asFloat();
            }
            catch (NumberFormatException e) {
                throw new NodeMappingException(e);
            }
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(element.getClass()));
    }
}

