/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapper.primitive_array;

import cool.scx.object.mapper.FromNodeContext;
import cool.scx.object.mapper.NodeMapper;
import cool.scx.object.mapper.NodeMappingException;
import cool.scx.object.mapper.ToNodeContext;
import cool.scx.object.node.ArrayNode;
import cool.scx.object.node.IntNode;
import cool.scx.object.node.Node;
import cool.scx.object.node.ValueNode;

public final class ShortArrayNodeMapper
implements NodeMapper<short[]> {
    @Override
    public Node toNode(short[] value, ToNodeContext context) {
        ArrayNode arrayNode = new ArrayNode(value.length);
        for (short i : value) {
            arrayNode.add(new IntNode(i));
        }
        return arrayNode;
    }

    @Override
    public short[] fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        if (node.isNull()) {
            return null;
        }
        if (node instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)node;
            short[] result = new short[arrayNode.size()];
            int i = 0;
            for (Node e : arrayNode) {
                result[i] = this.toShort(e);
                ++i;
            }
            return result;
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }

    private short toShort(Node element) throws NodeMappingException {
        if (element.isNull()) {
            throw new NodeMappingException("Element cannot be null");
        }
        if (element instanceof ValueNode) {
            ValueNode valueNode = (ValueNode)element;
            try {
                return (short)valueNode.asInt();
            }
            catch (NumberFormatException e) {
                throw new NodeMappingException(e);
            }
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(element.getClass()));
    }
}

