/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapper.time;

import cool.scx.object.mapper.FromNodeContext;
import cool.scx.object.mapper.NodeMapper;
import cool.scx.object.mapper.NodeMappingException;
import cool.scx.object.mapper.ToNodeContext;
import cool.scx.object.node.Node;
import cool.scx.object.node.TextNode;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public final class LocalDateTimeNodeMapper
implements NodeMapper<LocalDateTime> {
    private final DateTimeFormatter formatter;

    public LocalDateTimeNodeMapper(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    @Override
    public Node toNode(LocalDateTime value, ToNodeContext context) {
        return new TextNode(this.formatter.format(value));
    }

    @Override
    public LocalDateTime fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        if (node.isNull()) {
            return null;
        }
        if (node instanceof TextNode) {
            TextNode textNode = (TextNode)node;
            try {
                return LocalDateTime.parse(textNode.asText(), this.formatter);
            }
            catch (DateTimeParseException e) {
                throw new NodeMappingException(e);
            }
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }
}

