/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapper.time;

import cool.scx.object.mapper.FromNodeContext;
import cool.scx.object.mapper.NodeMapper;
import cool.scx.object.mapper.NodeMappingException;
import cool.scx.object.mapper.ToNodeContext;
import cool.scx.object.node.Node;
import cool.scx.object.node.TextNode;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public final class LocalTimeNodeMapper
implements NodeMapper<LocalTime> {
    private final DateTimeFormatter formatter;

    public LocalTimeNodeMapper(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    @Override
    public Node toNode(LocalTime value, ToNodeContext context) {
        return new TextNode(this.formatter.format(value));
    }

    @Override
    public LocalTime fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        if (node.isNull()) {
            return null;
        }
        if (node instanceof TextNode) {
            TextNode textNode = (TextNode)node;
            try {
                return LocalTime.parse(textNode.asText(), this.formatter);
            }
            catch (DateTimeParseException e) {
                throw new NodeMappingException(e);
            }
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }
}

