/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.node;

import cool.scx.object.node.NumberNode;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class BigIntegerNode
implements NumberNode {
    private final BigInteger _value;

    public BigIntegerNode(BigInteger v) {
        if (v == null) {
            throw new NullPointerException("BigIntegerNode value cannot be null");
        }
        this._value = v;
    }

    public BigInteger value() {
        return this._value;
    }

    @Override
    public int asInt() {
        return this._value.intValue();
    }

    @Override
    public long asLong() {
        return this._value.longValue();
    }

    @Override
    public float asFloat() {
        return this._value.floatValue();
    }

    @Override
    public double asDouble() {
        return this._value.doubleValue();
    }

    @Override
    public BigInteger asBigInteger() {
        return this._value;
    }

    @Override
    public BigDecimal asBigDecimal() {
        return new BigDecimal(this._value);
    }

    @Override
    public String asText() {
        return this._value.toString();
    }

    @Override
    public boolean asBoolean() {
        return !this._value.equals(BigInteger.ZERO);
    }

    @Override
    public BigIntegerNode deepCopy() {
        return this;
    }

    public boolean equals(Object object) {
        if (object instanceof BigIntegerNode) {
            BigIntegerNode bigIntegerNode = (BigIntegerNode)object;
            return this._value.equals(bigIntegerNode._value);
        }
        return false;
    }

    public int hashCode() {
        return this._value.hashCode();
    }

    public String toString() {
        return this.asText();
    }
}

