/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.node;

import cool.scx.object.node.Node;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ObjectNode
implements Node,
Iterable<Map.Entry<String, Node>> {
    private final Map<String, Node> _children;

    public ObjectNode() {
        this._children = new LinkedHashMap<String, Node>();
    }

    public ObjectNode(int initialCapacity) {
        this._children = new LinkedHashMap<String, Node>(initialCapacity);
    }

    public Node put(String name, Node value) {
        if (name == null) {
            throw new NullPointerException("ObjectNode cannot put null name");
        }
        if (value == null) {
            throw new NullPointerException("ObjectNode cannot put null value");
        }
        return this._children.put(name, value);
    }

    public Node get(String name) {
        return this._children.get(name);
    }

    public Node remove(String name) {
        return this._children.remove(name);
    }

    public int size() {
        return this._children.size();
    }

    @Override
    public Iterator<Map.Entry<String, Node>> iterator() {
        return this._children.entrySet().iterator();
    }

    @Override
    public ObjectNode deepCopy() {
        ObjectNode objectNode = new ObjectNode();
        for (Map.Entry<String, Node> entry : this) {
            objectNode.put(entry.getKey(), entry.getValue().deepCopy());
        }
        return objectNode;
    }

    public boolean equals(Object object) {
        if (object instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)object;
            return this._children.equals(objectNode._children);
        }
        return false;
    }

    public int hashCode() {
        return this._children.hashCode();
    }

    public String toString() {
        return this._children.toString();
    }
}

