/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapping;

import cool.scx.object.mapping.NodeMapper;
import cool.scx.object.mapping.NodeMapperFactory;
import cool.scx.object.mapping.NodeMappingException;
import cool.scx.object.mapping.mapper.StringNodeMapper;
import cool.scx.object.mapping.mapper.UntypedNodeMapper;
import cool.scx.object.mapping.mapper.math.BigDecimalNodeMapper;
import cool.scx.object.mapping.mapper.math.BigIntegerNodeMapper;
import cool.scx.object.mapping.mapper.node.ArrayNodeNodeMapper;
import cool.scx.object.mapping.mapper.node.BigDecimalNodeNodeMapper;
import cool.scx.object.mapping.mapper.node.BigIntegerNodeNodeMapper;
import cool.scx.object.mapping.mapper.node.BooleanNodeNodeMapper;
import cool.scx.object.mapping.mapper.node.DoubleNodeNodeMapper;
import cool.scx.object.mapping.mapper.node.FloatNodeNodeMapper;
import cool.scx.object.mapping.mapper.node.IntNodeNodeMapper;
import cool.scx.object.mapping.mapper.node.LongNodeNodeMapper;
import cool.scx.object.mapping.mapper.node.NodeNodeMapper;
import cool.scx.object.mapping.mapper.node.NullNodeNodeMapper;
import cool.scx.object.mapping.mapper.node.NumericNodeNodeMapper;
import cool.scx.object.mapping.mapper.node.ObjectNodeNodeMapper;
import cool.scx.object.mapping.mapper.node.TextNodeNodeMapper;
import cool.scx.object.mapping.mapper.node.ValueNodeNodeMapper;
import cool.scx.object.mapping.mapper.other.URINodeMapper;
import cool.scx.object.mapping.mapper.other.UUIDNodeMapper;
import cool.scx.object.mapping.mapper.primitive.BooleanNodeMapper;
import cool.scx.object.mapping.mapper.primitive.ByteNodeMapper;
import cool.scx.object.mapping.mapper.primitive.CharNodeMapper;
import cool.scx.object.mapping.mapper.primitive.DoubleNodeMapper;
import cool.scx.object.mapping.mapper.primitive.FloatNodeMapper;
import cool.scx.object.mapping.mapper.primitive.IntNodeMapper;
import cool.scx.object.mapping.mapper.primitive.LongNodeMapper;
import cool.scx.object.mapping.mapper.primitive.ShortNodeMapper;
import cool.scx.object.mapping.mapper.primitive_array.BooleanArrayNodeMapper;
import cool.scx.object.mapping.mapper.primitive_array.ByteArrayNodeMapper;
import cool.scx.object.mapping.mapper.primitive_array.CharArrayNodeMapper;
import cool.scx.object.mapping.mapper.primitive_array.DoubleArrayNodeMapper;
import cool.scx.object.mapping.mapper.primitive_array.FloatArrayNodeMapper;
import cool.scx.object.mapping.mapper.primitive_array.IntArrayNodeMapper;
import cool.scx.object.mapping.mapper.primitive_array.LongArrayNodeMapper;
import cool.scx.object.mapping.mapper.primitive_array.ShortArrayNodeMapper;
import cool.scx.object.mapping.mapper.time.DateNodeMapper;
import cool.scx.object.mapping.mapper.time.DurationNodeMapper;
import cool.scx.object.mapping.mapper.time.TemporalAccessorNodeMapper;
import cool.scx.object.mapping.mapper_factory.BeanNodeMapperFactory;
import cool.scx.object.mapping.mapper_factory.CollectionNodeMapperFactory;
import cool.scx.object.mapping.mapper_factory.EnumNodeMapperFactory;
import cool.scx.object.mapping.mapper_factory.MapNodeMapperFactory;
import cool.scx.object.mapping.mapper_factory.ObjectArrayNodeMapperFactory;
import cool.scx.object.mapping.mapper_factory.RecordNodeMapperFactory;
import cool.scx.object.node.ArrayNode;
import cool.scx.object.node.BigDecimalNode;
import cool.scx.object.node.BigIntegerNode;
import cool.scx.object.node.BooleanNode;
import cool.scx.object.node.DoubleNode;
import cool.scx.object.node.FloatNode;
import cool.scx.object.node.IntNode;
import cool.scx.object.node.LongNode;
import cool.scx.object.node.Node;
import cool.scx.object.node.NullNode;
import cool.scx.object.node.NumberNode;
import cool.scx.object.node.ObjectNode;
import cool.scx.object.node.TextNode;
import cool.scx.object.node.ValueNode;
import cool.scx.reflect.ScxReflect;
import cool.scx.reflect.TypeInfo;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class NodeMapperSelector {
    private final Map<Object, NodeMapper<?>> NODE_MAPPER_MAP = new ConcurrentHashMap();
    private final List<NodeMapperFactory> NODE_MAPPER_FACTORY_LIST = new ArrayList<NodeMapperFactory>();
    private final Lock LOCK = new ReentrantLock();

    public NodeMapperSelector() {
        this.registerNodeMapper(Byte.TYPE, new ByteNodeMapper(true));
        this.registerNodeMapper(Short.TYPE, new ShortNodeMapper(true));
        this.registerNodeMapper(Integer.TYPE, new IntNodeMapper(true));
        this.registerNodeMapper(Long.TYPE, new LongNodeMapper(true));
        this.registerNodeMapper(Float.TYPE, new FloatNodeMapper(true));
        this.registerNodeMapper(Double.TYPE, new DoubleNodeMapper(true));
        this.registerNodeMapper(Boolean.TYPE, new BooleanNodeMapper(true));
        this.registerNodeMapper(Character.TYPE, new CharNodeMapper(true));
        this.registerNodeMapper(Byte.class, new ByteNodeMapper(false));
        this.registerNodeMapper(Short.class, new ShortNodeMapper(false));
        this.registerNodeMapper(Integer.class, new IntNodeMapper(false));
        this.registerNodeMapper(Long.class, new LongNodeMapper(false));
        this.registerNodeMapper(Float.class, new FloatNodeMapper(false));
        this.registerNodeMapper(Double.class, new DoubleNodeMapper(false));
        this.registerNodeMapper(Boolean.class, new BooleanNodeMapper(false));
        this.registerNodeMapper(Character.class, new CharNodeMapper(false));
        this.registerNodeMapper(String.class, new StringNodeMapper());
        this.registerNodeMapper(BigInteger.class, new BigIntegerNodeMapper());
        this.registerNodeMapper(BigDecimal.class, new BigDecimalNodeMapper());
        this.registerNodeMapper(byte[].class, new ByteArrayNodeMapper());
        this.registerNodeMapper(short[].class, new ShortArrayNodeMapper());
        this.registerNodeMapper(int[].class, new IntArrayNodeMapper());
        this.registerNodeMapper(long[].class, new LongArrayNodeMapper());
        this.registerNodeMapper(float[].class, new FloatArrayNodeMapper());
        this.registerNodeMapper(double[].class, new DoubleArrayNodeMapper());
        this.registerNodeMapper(boolean[].class, new BooleanArrayNodeMapper());
        this.registerNodeMapper(char[].class, new CharArrayNodeMapper());
        this.registerNodeMapper(LocalDateTime.class, new TemporalAccessorNodeMapper<LocalDateTime>(DateTimeFormatter.ISO_LOCAL_DATE_TIME, LocalDateTime::from));
        this.registerNodeMapper(LocalDate.class, new TemporalAccessorNodeMapper<LocalDate>(DateTimeFormatter.ISO_LOCAL_DATE, LocalDate::from));
        this.registerNodeMapper(LocalTime.class, new TemporalAccessorNodeMapper<LocalTime>(DateTimeFormatter.ISO_LOCAL_TIME, LocalTime::from));
        this.registerNodeMapper(OffsetDateTime.class, new TemporalAccessorNodeMapper<OffsetDateTime>(DateTimeFormatter.ISO_OFFSET_DATE_TIME, OffsetDateTime::from));
        this.registerNodeMapper(OffsetTime.class, new TemporalAccessorNodeMapper<OffsetTime>(DateTimeFormatter.ISO_OFFSET_TIME, OffsetTime::from));
        this.registerNodeMapper(ZonedDateTime.class, new TemporalAccessorNodeMapper<ZonedDateTime>(DateTimeFormatter.ISO_ZONED_DATE_TIME, ZonedDateTime::from));
        this.registerNodeMapper(Year.class, new TemporalAccessorNodeMapper<Year>(DateTimeFormatter.ofPattern("yyyy"), Year::from));
        this.registerNodeMapper(Month.class, new TemporalAccessorNodeMapper<Month>(DateTimeFormatter.ofPattern("MM"), Month::from));
        this.registerNodeMapper(MonthDay.class, new TemporalAccessorNodeMapper<MonthDay>(DateTimeFormatter.ofPattern("--MM-dd"), MonthDay::from));
        this.registerNodeMapper(YearMonth.class, new TemporalAccessorNodeMapper<YearMonth>(DateTimeFormatter.ofPattern("yyyy-MM"), YearMonth::from));
        this.registerNodeMapper(DayOfWeek.class, new TemporalAccessorNodeMapper<DayOfWeek>(DateTimeFormatter.ofPattern("e"), DayOfWeek::from));
        this.registerNodeMapper(Instant.class, new TemporalAccessorNodeMapper<Instant>(DateTimeFormatter.ISO_INSTANT, Instant::from));
        this.registerNodeMapper(Duration.class, new DurationNodeMapper());
        this.registerNodeMapper(Date.class, new DateNodeMapper());
        this.registerNodeMapper(IntNode.class, new IntNodeNodeMapper());
        this.registerNodeMapper(LongNode.class, new LongNodeNodeMapper());
        this.registerNodeMapper(FloatNode.class, new FloatNodeNodeMapper());
        this.registerNodeMapper(DoubleNode.class, new DoubleNodeNodeMapper());
        this.registerNodeMapper(BigIntegerNode.class, new BigIntegerNodeNodeMapper());
        this.registerNodeMapper(BigDecimalNode.class, new BigDecimalNodeNodeMapper());
        this.registerNodeMapper(TextNode.class, new TextNodeNodeMapper());
        this.registerNodeMapper(BooleanNode.class, new BooleanNodeNodeMapper());
        this.registerNodeMapper(ValueNode.class, new ValueNodeNodeMapper());
        this.registerNodeMapper(NumberNode.class, new NumericNodeNodeMapper());
        this.registerNodeMapper(NullNode.class, new NullNodeNodeMapper());
        this.registerNodeMapper(ArrayNode.class, new ArrayNodeNodeMapper());
        this.registerNodeMapper(ObjectNode.class, new ObjectNodeNodeMapper());
        this.registerNodeMapper(Node.class, new NodeNodeMapper());
        this.registerNodeMapper(Object.class, new UntypedNodeMapper());
        this.registerNodeMapper(UUID.class, new UUIDNodeMapper());
        this.registerNodeMapper(URI.class, new URINodeMapper());
        this.registerNodeMapperFactory(new ObjectArrayNodeMapperFactory());
        this.registerNodeMapperFactory(new CollectionNodeMapperFactory());
        this.registerNodeMapperFactory(new MapNodeMapperFactory());
        this.registerNodeMapperFactory(new BeanNodeMapperFactory());
        this.registerNodeMapperFactory(new RecordNodeMapperFactory());
        this.registerNodeMapperFactory(new EnumNodeMapperFactory());
    }

    public <T> void registerNodeMapper(TypeInfo type, NodeMapper<T> typeHandler) {
        this.NODE_MAPPER_MAP.put(type, typeHandler);
    }

    public <T> void registerNodeMapper(Class<T> type, NodeMapper<T> typeHandler) {
        this.NODE_MAPPER_MAP.put(type, typeHandler);
        this.NODE_MAPPER_MAP.put(ScxReflect.typeOf(type), typeHandler);
    }

    public void registerNodeMapperFactory(NodeMapperFactory nodeMapperFactory) {
        this.NODE_MAPPER_FACTORY_LIST.add(nodeMapperFactory);
    }

    public void registerNodeMapperFactory(NodeMapperFactory nodeMapperFactory, int order) {
        this.NODE_MAPPER_FACTORY_LIST.add(order, nodeMapperFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> NodeMapper<T> findNodeMapper(TypeInfo type) throws NodeMappingException {
        NodeMapper<?> nodeMapper = this.NODE_MAPPER_MAP.get(type);
        if (nodeMapper != null) {
            return nodeMapper;
        }
        this.LOCK.lock();
        try {
            nodeMapper = this.NODE_MAPPER_MAP.get(type);
            if (nodeMapper != null) {
                NodeMapper<?> nodeMapper2 = nodeMapper;
                return nodeMapper2;
            }
            nodeMapper = this.createNodeMapper(type);
            this.NODE_MAPPER_MAP.put(type, nodeMapper);
            NodeMapper<?> nodeMapper3 = nodeMapper;
            return nodeMapper3;
        }
        finally {
            this.LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> NodeMapper<T> findNodeMapper(Class<T> type) throws NodeMappingException {
        NodeMapper<?> nodeMapper = this.NODE_MAPPER_MAP.get(type);
        if (nodeMapper != null) {
            return nodeMapper;
        }
        this.LOCK.lock();
        try {
            nodeMapper = this.NODE_MAPPER_MAP.get(type);
            if (nodeMapper != null) {
                NodeMapper<?> nodeMapper2 = nodeMapper;
                return nodeMapper2;
            }
            TypeInfo typeInfo = ScxReflect.typeOf(type);
            NodeMapper<?> oldNodeMapper = this.NODE_MAPPER_MAP.get(typeInfo);
            if (oldNodeMapper != null) {
                this.NODE_MAPPER_MAP.put(type, oldNodeMapper);
                NodeMapper<?> nodeMapper3 = oldNodeMapper;
                return nodeMapper3;
            }
            nodeMapper = this.createNodeMapper(typeInfo);
            this.NODE_MAPPER_MAP.put(type, nodeMapper);
            this.NODE_MAPPER_MAP.put(typeInfo, nodeMapper);
            NodeMapper<?> nodeMapper4 = nodeMapper;
            return nodeMapper4;
        }
        finally {
            this.LOCK.unlock();
        }
    }

    private NodeMapper<?> createNodeMapper(TypeInfo typeInfo) throws NodeMappingException {
        for (NodeMapperFactory factory : this.NODE_MAPPER_FACTORY_LIST) {
            NodeMapper<?> nodeMapper = factory.createNodeMapper(typeInfo, this);
            if (nodeMapper == null) continue;
            return nodeMapper;
        }
        throw new NodeMappingException("No NodeMapper found for type " + String.valueOf(typeInfo));
    }
}

