/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapping;

import cool.scx.object.mapping.NodeMapper;
import cool.scx.object.mapping.NodeMapperSelector;
import cool.scx.object.mapping.NodeMappingException;
import cool.scx.object.mapping.ToNodeContext;
import cool.scx.object.mapping.ToNodeOptions;
import cool.scx.object.mapping.ToNodeOptionsImpl;
import cool.scx.object.node.Node;
import cool.scx.object.node.NullNode;

public final class ToNodeContextImpl
implements ToNodeContext {
    private final NodeMapperSelector selector;
    private final ToNodeOptionsImpl options;
    private int nestingDepth;

    public ToNodeContextImpl(NodeMapperSelector selector, ToNodeOptionsImpl options) {
        this.selector = selector;
        this.options = options;
        this.nestingDepth = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node toNode(Object value, Object pathSegment) throws NodeMappingException {
        if (value == null) {
            return NullNode.NULL;
        }
        if (this.nestingDepth > this.options.maxNestingDepth()) {
            throw new NodeMappingException("\u5d4c\u5957\u6df1\u5ea6\u8d85\u8fc7\u9650\u5236: \u6700\u5927 " + this.options.maxNestingDepth());
        }
        ++this.nestingDepth;
        try {
            NodeMapper<?> nodeMapper = this.selector.findNodeMapper(value.getClass());
            Node node = nodeMapper.toNode(value, this);
            return node;
        }
        finally {
            --this.nestingDepth;
        }
    }

    @Override
    public ToNodeOptions options() {
        return this.options;
    }
}

