/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapping.mapper.other;

import cool.scx.object.mapping.FromNodeContext;
import cool.scx.object.mapping.NodeMapper;
import cool.scx.object.mapping.NodeMappingException;
import cool.scx.object.mapping.ToNodeContext;
import cool.scx.object.node.Node;
import cool.scx.object.node.TextNode;
import java.net.URI;

public final class URINodeMapper
implements NodeMapper<URI> {
    @Override
    public Node toNode(URI value, ToNodeContext context) throws NodeMappingException {
        return new TextNode(value.toString());
    }

    @Override
    public URI fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        if (node.isNull()) {
            return null;
        }
        if (node instanceof TextNode) {
            TextNode textNode = (TextNode)node;
            String value = textNode.value();
            try {
                return URI.create(value);
            }
            catch (IllegalArgumentException e) {
                throw new NodeMappingException(e);
            }
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }
}

