/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapping.mapper.primitive;

import cool.scx.object.mapping.FromNodeContext;
import cool.scx.object.mapping.NodeMapper;
import cool.scx.object.mapping.NodeMappingException;
import cool.scx.object.mapping.ToNodeContext;
import cool.scx.object.node.IntNode;
import cool.scx.object.node.Node;
import cool.scx.object.node.ValueNode;

public final class ByteNodeMapper
implements NodeMapper<Byte> {
    private final boolean isPrimitive;

    public ByteNodeMapper(boolean isPrimitive) {
        this.isPrimitive = isPrimitive;
    }

    @Override
    public Node toNode(Byte value, ToNodeContext context) {
        return new IntNode(value.byteValue());
    }

    @Override
    public Byte fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        if (node.isNull()) {
            return this.isPrimitive ? Byte.valueOf((byte)0) : null;
        }
        if (node instanceof ValueNode) {
            ValueNode valueNode = (ValueNode)node;
            try {
                return (byte)valueNode.asInt();
            }
            catch (NumberFormatException e) {
                throw new NodeMappingException(e);
            }
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }
}

