/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapping.mapper.primitive_array;

import cool.scx.object.mapping.FromNodeContext;
import cool.scx.object.mapping.NodeMapper;
import cool.scx.object.mapping.NodeMappingException;
import cool.scx.object.mapping.ToNodeContext;
import cool.scx.object.node.ArrayNode;
import cool.scx.object.node.Node;
import cool.scx.object.node.TextNode;

public final class CharArrayNodeMapper
implements NodeMapper<char[]> {
    @Override
    public Node toNode(char[] value, ToNodeContext context) {
        ArrayNode arrayNode = new ArrayNode(value.length);
        for (char i : value) {
            arrayNode.add(new TextNode(String.valueOf(i)));
        }
        return arrayNode;
    }

    @Override
    public char[] fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        if (node.isNull()) {
            return null;
        }
        if (node instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)node;
            char[] result = new char[arrayNode.size()];
            int i = 0;
            for (Node e : arrayNode) {
                result[i] = this.toChar(e);
                ++i;
            }
            return result;
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }

    private char toChar(Node element) throws NodeMappingException {
        if (element.isNull()) {
            throw new NodeMappingException("Element cannot be null");
        }
        if (element instanceof TextNode) {
            TextNode textNode = (TextNode)element;
            String text = textNode.asText();
            if (text.length() == 1) {
                return text.charAt(0);
            }
            throw new NodeMappingException("String length must be 1 for char, got: " + text);
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(element.getClass()));
    }
}

