/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapping.mapper.primitive_array;

import cool.scx.object.mapping.FromNodeContext;
import cool.scx.object.mapping.NodeMapper;
import cool.scx.object.mapping.NodeMappingException;
import cool.scx.object.mapping.ToNodeContext;
import cool.scx.object.node.ArrayNode;
import cool.scx.object.node.IntNode;
import cool.scx.object.node.Node;
import cool.scx.object.node.ValueNode;

public final class IntArrayNodeMapper
implements NodeMapper<int[]> {
    @Override
    public Node toNode(int[] value, ToNodeContext context) {
        ArrayNode arrayNode = new ArrayNode(value.length);
        for (int i : value) {
            arrayNode.add(new IntNode(i));
        }
        return arrayNode;
    }

    @Override
    public int[] fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        if (node.isNull()) {
            return null;
        }
        if (node instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)node;
            int[] result = new int[arrayNode.size()];
            int i = 0;
            for (Node e : arrayNode) {
                result[i] = this.toInt(e);
                ++i;
            }
            return result;
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }

    private int toInt(Node element) throws NodeMappingException {
        if (element.isNull()) {
            throw new NodeMappingException("Element cannot be null");
        }
        if (element instanceof ValueNode) {
            ValueNode valueNode = (ValueNode)element;
            try {
                return valueNode.asInt();
            }
            catch (NumberFormatException e) {
                throw new NodeMappingException(e);
            }
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(element.getClass()));
    }
}

