/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapping.mapper.primitive;

import cool.scx.object.mapping.FromNodeContext;
import cool.scx.object.mapping.NodeMapper;
import cool.scx.object.mapping.NodeMappingException;
import cool.scx.object.mapping.ToNodeContext;
import cool.scx.object.node.DoubleNode;
import cool.scx.object.node.Node;
import cool.scx.object.node.ValueNode;

public final class DoubleNodeMapper
implements NodeMapper<Double> {
    private final boolean isPrimitive;

    public DoubleNodeMapper(boolean isPrimitive) {
        this.isPrimitive = isPrimitive;
    }

    @Override
    public Node toNode(Double value, ToNodeContext context) {
        return new DoubleNode(value);
    }

    @Override
    public Double fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        if (node.isNull()) {
            return this.isPrimitive ? Double.valueOf(0.0) : null;
        }
        if (node instanceof ValueNode) {
            ValueNode valueNode = (ValueNode)node;
            try {
                return valueNode.asDouble();
            }
            catch (NumberFormatException e) {
                throw new NodeMappingException(e);
            }
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }
}

