/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapping.mapper.primitive;

import cool.scx.object.mapping.FromNodeContext;
import cool.scx.object.mapping.NodeMapper;
import cool.scx.object.mapping.NodeMappingException;
import cool.scx.object.mapping.ToNodeContext;
import cool.scx.object.node.IntNode;
import cool.scx.object.node.Node;
import cool.scx.object.node.ValueNode;

public final class IntNodeMapper
implements NodeMapper<Integer> {
    private final boolean isPrimitive;

    public IntNodeMapper(boolean isPrimitive) {
        this.isPrimitive = isPrimitive;
    }

    @Override
    public Node toNode(Integer value, ToNodeContext context) {
        return new IntNode(value);
    }

    @Override
    public Integer fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        if (node.isNull()) {
            return this.isPrimitive ? Integer.valueOf(0) : null;
        }
        if (node instanceof ValueNode) {
            ValueNode valueNode = (ValueNode)node;
            try {
                return valueNode.asInt();
            }
            catch (NumberFormatException e) {
                throw new NodeMappingException(e);
            }
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }
}

