/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapping.mapper.primitive;

import cool.scx.object.mapping.FromNodeContext;
import cool.scx.object.mapping.NodeMapper;
import cool.scx.object.mapping.NodeMappingException;
import cool.scx.object.mapping.ToNodeContext;
import cool.scx.object.node.LongNode;
import cool.scx.object.node.Node;
import cool.scx.object.node.ValueNode;

public final class LongNodeMapper
implements NodeMapper<Long> {
    private final boolean isPrimitive;

    public LongNodeMapper(boolean isPrimitive) {
        this.isPrimitive = isPrimitive;
    }

    @Override
    public Node toNode(Long value, ToNodeContext context) {
        return new LongNode(value);
    }

    @Override
    public Long fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        if (node.isNull()) {
            return this.isPrimitive ? Long.valueOf(0L) : null;
        }
        if (node instanceof ValueNode) {
            ValueNode valueNode = (ValueNode)node;
            try {
                return valueNode.asLong();
            }
            catch (NumberFormatException e) {
                throw new NodeMappingException(e);
            }
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }
}

