/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapping.mapper;

import cool.scx.object.mapping.FromNodeContext;
import cool.scx.object.mapping.NodeMapper;
import cool.scx.object.mapping.NodeMappingException;
import cool.scx.object.mapping.ToNodeContext;
import cool.scx.object.node.ArrayNode;
import cool.scx.object.node.Node;
import cool.scx.reflect.ClassInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public final class CollectionNodeMapper
implements NodeMapper<Collection<?>> {
    private final ClassInfo classInfo;
    private final NodeMapper<Object> componentNodeMapper;

    public CollectionNodeMapper(ClassInfo classInfo, NodeMapper<Object> componentNodeMapper) {
        this.classInfo = classInfo;
        this.componentNodeMapper = componentNodeMapper;
    }

    @Override
    public Node toNode(Collection<?> value, ToNodeContext context) throws NodeMappingException {
        ArrayNode arrayNode = new ArrayNode(value.size());
        int i = 0;
        for (Object a : value) {
            arrayNode.add(context.toNode(a, i));
            ++i;
        }
        return arrayNode;
    }

    @Override
    public Collection<?> fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        if (node.isNull()) {
            return null;
        }
        if (node instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)node;
            Collection<Object> result = this.createCollection(arrayNode.size());
            for (Node n : arrayNode) {
                Object i = this.componentNodeMapper.fromNode(n, context);
                result.add(i);
            }
            return result;
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }

    private Collection<Object> createCollection(int size) throws NodeMappingException {
        if (this.classInfo.rawClass() == Collection.class) {
            return new ArrayList<Object>(size);
        }
        if (this.classInfo.rawClass() == List.class) {
            return new ArrayList<Object>(size);
        }
        if (this.classInfo.rawClass() == Set.class) {
            return new HashSet<Object>(size);
        }
        if (this.classInfo.rawClass() == ArrayList.class) {
            return new ArrayList<Object>(size);
        }
        if (this.classInfo.rawClass() == LinkedList.class) {
            return new LinkedList<Object>();
        }
        if (this.classInfo.rawClass() == HashSet.class) {
            return new HashSet<Object>(size);
        }
        if (this.classInfo.rawClass() == TreeSet.class) {
            return new TreeSet<Object>();
        }
        if (this.classInfo.rawClass() == LinkedHashSet.class) {
            return new LinkedHashSet<Object>(size);
        }
        throw new NodeMappingException("Unsupported Collection type: " + String.valueOf(this.classInfo));
    }
}

