/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapping.mapper.primitive_array;

import cool.scx.object.mapping.FromNodeContext;
import cool.scx.object.mapping.NodeMapper;
import cool.scx.object.mapping.NodeMappingException;
import cool.scx.object.mapping.ToNodeContext;
import cool.scx.object.node.ArrayNode;
import cool.scx.object.node.LongNode;
import cool.scx.object.node.Node;
import cool.scx.object.node.ValueNode;

public final class LongArrayNodeMapper
implements NodeMapper<long[]> {
    @Override
    public Node toNode(long[] value, ToNodeContext context) {
        ArrayNode arrayNode = new ArrayNode(value.length);
        for (long i : value) {
            arrayNode.add(new LongNode(i));
        }
        return arrayNode;
    }

    @Override
    public long[] fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        if (node.isNull()) {
            return null;
        }
        if (node instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)node;
            long[] result = new long[arrayNode.size()];
            int i = 0;
            for (Node e : arrayNode) {
                result[i] = this.toLong(e);
                ++i;
            }
            return result;
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }

    private long toLong(Node element) throws NodeMappingException {
        if (element.isNull()) {
            throw new NodeMappingException("Element cannot be null");
        }
        if (element instanceof ValueNode) {
            ValueNode valueNode = (ValueNode)element;
            try {
                return valueNode.asLong();
            }
            catch (NumberFormatException e) {
                throw new NodeMappingException(e);
            }
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(element.getClass()));
    }
}

