/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapping.mapper.time;

import cool.scx.object.mapping.FromNodeContext;
import cool.scx.object.mapping.NodeMapper;
import cool.scx.object.mapping.NodeMappingException;
import cool.scx.object.mapping.ToNodeContext;
import cool.scx.object.node.Node;
import cool.scx.object.node.TextNode;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Date;

public final class DateNodeMapper
implements NodeMapper<Date> {
    @Override
    public Node toNode(Date value, ToNodeContext context) {
        return new TextNode(Instant.ofEpochMilli(value.getTime()).toString());
    }

    @Override
    public Date fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        if (node.isNull()) {
            return null;
        }
        if (node instanceof TextNode) {
            TextNode textNode = (TextNode)node;
            try {
                return Date.from(Instant.parse(textNode.asText()));
            }
            catch (DateTimeParseException e) {
                throw new NodeMappingException(e);
            }
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }
}

