/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapping.mapper.time;

import cool.scx.object.mapping.FromNodeContext;
import cool.scx.object.mapping.NodeMapper;
import cool.scx.object.mapping.NodeMappingException;
import cool.scx.object.mapping.ToNodeContext;
import cool.scx.object.node.Node;
import cool.scx.object.node.TextNode;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;

public final class TemporalAccessorNodeMapper<T extends TemporalAccessor>
implements NodeMapper<T> {
    private final DateTimeFormatter formatter;
    private final TemporalQuery<T> temporalQuery;

    public TemporalAccessorNodeMapper(DateTimeFormatter formatter, TemporalQuery<T> temporalQuery) {
        this.formatter = formatter;
        this.temporalQuery = temporalQuery;
    }

    @Override
    public Node toNode(T value, ToNodeContext context) {
        return new TextNode(this.formatter.format((TemporalAccessor)value));
    }

    @Override
    public T fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        if (node.isNull()) {
            return null;
        }
        if (node instanceof TextNode) {
            TextNode textNode = (TextNode)node;
            try {
                return (T)((TemporalAccessor)this.formatter.parse((CharSequence)textNode.asText(), this.temporalQuery));
            }
            catch (DateTimeParseException e) {
                throw new NodeMappingException(e);
            }
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }
}

