/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.node;

import cool.scx.object.node.ValueNode;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class BooleanNode
implements ValueNode {
    public static final BooleanNode TRUE = new BooleanNode(true);
    public static final BooleanNode FALSE = new BooleanNode(false);
    private final boolean _value;

    private BooleanNode(boolean v) {
        this._value = v;
    }

    public static BooleanNode of(boolean v) {
        return v ? TRUE : FALSE;
    }

    public boolean value() {
        return this._value;
    }

    @Override
    public int asInt() {
        return this._value ? 1 : 0;
    }

    @Override
    public long asLong() {
        return this._value ? 1L : 0L;
    }

    @Override
    public float asFloat() {
        return this._value ? 1.0f : 0.0f;
    }

    @Override
    public double asDouble() {
        return this._value ? 1.0 : 0.0;
    }

    @Override
    public BigInteger asBigInteger() {
        return this._value ? BigInteger.ONE : BigInteger.ZERO;
    }

    @Override
    public BigDecimal asBigDecimal() {
        return this._value ? BigDecimal.ONE : BigDecimal.ZERO;
    }

    @Override
    public String asText() {
        return String.valueOf(this._value);
    }

    @Override
    public boolean asBoolean() {
        return this._value;
    }

    @Override
    public BooleanNode deepCopy() {
        return this;
    }

    public boolean equals(Object object) {
        if (object instanceof BooleanNode) {
            BooleanNode booleanNode = (BooleanNode)object;
            return this._value == booleanNode._value;
        }
        return false;
    }

    public int hashCode() {
        return Boolean.hashCode(this._value);
    }

    public String toString() {
        return this.asText();
    }
}

