/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.node;

import cool.scx.object.node.NumberNode;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class FloatNode
implements NumberNode {
    private final float _value;

    public FloatNode(float v) {
        this._value = v;
    }

    public float value() {
        return this._value;
    }

    @Override
    public int asInt() {
        return (int)this._value;
    }

    @Override
    public long asLong() {
        return (long)this._value;
    }

    @Override
    public float asFloat() {
        return this._value;
    }

    @Override
    public double asDouble() {
        return this._value;
    }

    @Override
    public BigInteger asBigInteger() {
        return BigDecimal.valueOf(this._value).toBigInteger();
    }

    @Override
    public BigDecimal asBigDecimal() {
        return BigDecimal.valueOf(this._value);
    }

    @Override
    public String asText() {
        return String.valueOf(this._value);
    }

    @Override
    public boolean asBoolean() {
        return this._value != 0.0f;
    }

    @Override
    public FloatNode deepCopy() {
        return this;
    }

    public boolean equals(Object object) {
        if (object instanceof FloatNode) {
            FloatNode floatNode = (FloatNode)object;
            return Float.compare(this._value, floatNode._value) == 0;
        }
        return false;
    }

    public int hashCode() {
        return Float.hashCode(this._value);
    }

    public String toString() {
        return this.asText();
    }
}

