/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.node;

import cool.scx.object.node.ValueNode;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class TextNode
implements ValueNode {
    private final String _value;

    public TextNode(String v) {
        if (v == null) {
            throw new NullPointerException("TextNode value cannot be null");
        }
        this._value = v;
    }

    public String value() {
        return this._value;
    }

    @Override
    public int asInt() throws NumberFormatException {
        return Integer.parseInt(this._value);
    }

    @Override
    public long asLong() throws NumberFormatException {
        return Long.parseLong(this._value);
    }

    @Override
    public float asFloat() throws NumberFormatException {
        return Float.parseFloat(this._value);
    }

    @Override
    public double asDouble() throws NumberFormatException {
        return Double.parseDouble(this._value);
    }

    @Override
    public BigInteger asBigInteger() throws NumberFormatException {
        return new BigInteger(this._value);
    }

    @Override
    public BigDecimal asBigDecimal() throws NumberFormatException {
        return new BigDecimal(this._value);
    }

    @Override
    public String asText() {
        return this._value;
    }

    @Override
    public boolean asBoolean() {
        return Boolean.parseBoolean(this._value);
    }

    @Override
    public TextNode deepCopy() {
        return this;
    }

    public boolean equals(Object object) {
        if (object instanceof TextNode) {
            TextNode textNode = (TextNode)object;
            return this._value.equals(textNode._value);
        }
        return false;
    }

    public int hashCode() {
        return this._value.hashCode();
    }

    public String toString() {
        return this.asText();
    }
}

