/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.parser.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.StreamReadConstraints;
import cool.scx.object.node.ArrayNode;
import cool.scx.object.node.BigDecimalNode;
import cool.scx.object.node.BigIntegerNode;
import cool.scx.object.node.BooleanNode;
import cool.scx.object.node.DoubleNode;
import cool.scx.object.node.FloatNode;
import cool.scx.object.node.IntNode;
import cool.scx.object.node.LongNode;
import cool.scx.object.node.Node;
import cool.scx.object.node.NullNode;
import cool.scx.object.node.ObjectNode;
import cool.scx.object.node.TextNode;
import cool.scx.object.parser.NodeParseException;
import cool.scx.object.parser.NodeParser;
import cool.scx.object.parser.json.DuplicateFieldPolicy;
import cool.scx.object.parser.json.JsonNodeParserOptions;
import java.io.File;
import java.io.IOException;

public final class JsonNodeParser
implements NodeParser {
    private final JsonFactory jsonFactory;
    private final JsonNodeParserOptions options;

    public JsonNodeParser(JsonFactory jsonFactory, JsonNodeParserOptions options) {
        this.jsonFactory = jsonFactory;
        this.options = options;
        this.jsonFactory.setStreamReadConstraints(StreamReadConstraints.builder().maxNestingDepth(options.maxNestingDepth()).maxStringLength(options.maxStringLength()).maxNumberLength(options.maxNumberLength()).maxNameLength(options.maxFieldNameLength()).build());
    }

    @Override
    public Node parse(String json) throws NodeParseException {
        try {
            return this.parseAndClose(this.jsonFactory.createParser(json));
        }
        catch (JsonProcessingException e) {
            throw new NodeParseException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Node parse(File file) throws NodeParseException, IOException {
        try {
            return this.parseAndClose(this.jsonFactory.createParser(file));
        }
        catch (JsonProcessingException e) {
            throw new NodeParseException(e);
        }
    }

    private Node parseAndClose(JsonParser parser) throws IOException {
        try (JsonParser jsonParser = parser;){
            JsonToken firstToken = parser.nextToken();
            if (firstToken == null) {
                throw new JsonParseException(parser, "\u672a\u68c0\u6d4b\u5230\u4efb\u4f55\u6709\u6548\u5185\u5bb9");
            }
            Node node = this.parseNode(parser);
            JsonToken trailingToken = parser.nextToken();
            if (trailingToken != null) {
                throw new JsonParseException(parser, "\u68c0\u6d4b\u5230\u591a\u4f59\u5185\u5bb9");
            }
            Node node2 = node;
            return node2;
        }
    }

    private Node parseNode(JsonParser parser) throws IOException {
        JsonToken currentToken = parser.currentToken();
        return switch (currentToken) {
            case JsonToken.START_OBJECT -> this.parseObject(parser);
            case JsonToken.START_ARRAY -> this.parseArray(parser);
            default -> this.parseScalar(parser);
        };
    }

    private Node parseObject(JsonParser parser) throws IOException {
        ObjectNode objectNode = new ObjectNode();
        int fieldCount = 0;
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            if (fieldCount >= this.options.maxFieldCount()) {
                throw new JsonParseException(parser, "\u5bf9\u8c61\u5b57\u6bb5\u6570\u8d85\u8fc7\u9650\u5236: \u6700\u5927 " + this.options.maxFieldCount());
            }
            String fieldName = parser.currentName();
            parser.nextToken();
            Node childNode = this.parseNode(parser);
            Node oldChildNode = objectNode.get(fieldName);
            if (oldChildNode == null) {
                objectNode.put(fieldName, childNode);
            } else {
                this.handleDuplicateField(parser, fieldName, objectNode, oldChildNode, childNode);
            }
            ++fieldCount;
        }
        return objectNode;
    }

    private Node parseArray(JsonParser parser) throws IOException {
        ArrayNode arrayNode = new ArrayNode();
        int arraySize = 0;
        while (parser.nextToken() != JsonToken.END_ARRAY) {
            if (arraySize >= this.options.maxArraySize()) {
                throw new JsonParseException(parser, "\u6570\u7ec4\u957f\u5ea6\u8d85\u8fc7\u9650\u5236: \u6700\u5927 " + this.options.maxArraySize());
            }
            Node childNode = this.parseNode(parser);
            arrayNode.add(childNode);
            ++arraySize;
        }
        return arrayNode;
    }

    private Node parseScalar(JsonParser parser) throws IOException {
        JsonToken currentToken = parser.currentToken();
        return switch (currentToken) {
            case JsonToken.VALUE_STRING -> new TextNode(parser.getText());
            case JsonToken.VALUE_NUMBER_INT -> this.parseInt(parser);
            case JsonToken.VALUE_NUMBER_FLOAT -> this.parseFloat(parser);
            case JsonToken.VALUE_TRUE -> BooleanNode.TRUE;
            case JsonToken.VALUE_FALSE -> BooleanNode.FALSE;
            case JsonToken.VALUE_NULL -> NullNode.NULL;
            default -> throw new JsonParseException(parser, "Unsupported token: " + String.valueOf(currentToken));
        };
    }

    private Node parseInt(JsonParser parser) throws IOException {
        JsonParser.NumberType numberType = parser.getNumberType();
        return switch (numberType) {
            case JsonParser.NumberType.INT -> new IntNode(parser.getIntValue());
            case JsonParser.NumberType.LONG -> new LongNode(parser.getLongValue());
            case JsonParser.NumberType.BIG_INTEGER -> new BigIntegerNode(parser.getBigIntegerValue());
            default -> throw new JsonParseException(parser, "Unsupported number type: " + String.valueOf(numberType));
        };
    }

    private Node parseFloat(JsonParser parser) throws IOException {
        JsonParser.NumberType numberType = parser.getNumberType();
        return switch (numberType) {
            case JsonParser.NumberType.FLOAT -> new FloatNode(parser.getFloatValue());
            case JsonParser.NumberType.DOUBLE -> new DoubleNode(parser.getDoubleValue());
            case JsonParser.NumberType.BIG_DECIMAL -> new BigDecimalNode(parser.getDecimalValue());
            default -> throw new JsonParseException(parser, "Unsupported number type: " + String.valueOf(numberType));
        };
    }

    private void handleDuplicateField(JsonParser parser, String fieldName, ObjectNode parentNode, Node oldChildNode, Node newChildNode) throws JsonParseException {
        DuplicateFieldPolicy duplicateFieldPolicy = this.options.duplicateFieldPolicy();
        switch (duplicateFieldPolicy) {
            case COVER: {
                parentNode.put(fieldName, newChildNode);
                break;
            }
            case IGNORE: {
                break;
            }
            case THROW: {
                throw new JsonParseException(parser, "\u68c0\u6d4b\u5230\u91cd\u590d\u5b57\u6bb5: \"" + fieldName + "\"");
            }
            case MERGE: {
                if (oldChildNode instanceof ArrayNode) {
                    ArrayNode arrayNode = (ArrayNode)oldChildNode;
                    arrayNode.add(newChildNode);
                    break;
                }
                ArrayNode arrayNode = new ArrayNode();
                arrayNode.add(oldChildNode);
                arrayNode.add(newChildNode);
                parentNode.put(fieldName, arrayNode);
            }
        }
    }
}

