/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.serializer.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.StreamWriteConstraints;
import cool.scx.object.node.ArrayNode;
import cool.scx.object.node.BigDecimalNode;
import cool.scx.object.node.BigIntegerNode;
import cool.scx.object.node.BooleanNode;
import cool.scx.object.node.DoubleNode;
import cool.scx.object.node.FloatNode;
import cool.scx.object.node.IntNode;
import cool.scx.object.node.LongNode;
import cool.scx.object.node.Node;
import cool.scx.object.node.NullNode;
import cool.scx.object.node.ObjectNode;
import cool.scx.object.node.TextNode;
import cool.scx.object.serializer.NodeSerializeException;
import cool.scx.object.serializer.NodeSerializer;
import cool.scx.object.serializer.json.JsonNodeSerializerOptions;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;

public final class JsonNodeSerializer
implements NodeSerializer {
    private final JsonFactory jsonFactory;
    private final JsonNodeSerializerOptions options;

    public JsonNodeSerializer(JsonFactory jsonFactory, JsonNodeSerializerOptions options) {
        this.jsonFactory = jsonFactory;
        this.options = options;
        this.jsonFactory.setStreamWriteConstraints(StreamWriteConstraints.builder().maxNestingDepth(options.maxNestingDepth()).build());
    }

    @Override
    public String serializeAsString(Node node) throws NodeSerializeException {
        StringWriter writer = new StringWriter();
        try {
            this.serializeAndClose(this.jsonFactory.createGenerator((Writer)writer), node);
        }
        catch (JsonProcessingException e) {
            throw new NodeSerializeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }

    private void serializeAndClose(JsonGenerator generator, Node node) throws IOException {
        try (JsonGenerator jsonGenerator = generator;){
            this.writeNode(generator, node);
        }
    }

    private void writeNode(JsonGenerator generator, Node node) throws IOException {
        Node node2 = node;
        Objects.requireNonNull(node2);
        Node node3 = node2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ObjectNode.class, ArrayNode.class}, (Node)node3, n)) {
            case 0: {
                ObjectNode objectNode = (ObjectNode)node3;
                this.writeObject(generator, objectNode);
                break;
            }
            case 1: {
                ArrayNode arrayNode = (ArrayNode)node3;
                this.writeArray(generator, arrayNode);
                break;
            }
            default: {
                this.writeScalar(generator, node);
            }
        }
    }

    private void writeObject(JsonGenerator generator, ObjectNode objectNode) throws IOException {
        generator.writeStartObject();
        for (Map.Entry<String, Node> e : objectNode) {
            generator.writeFieldName(e.getKey());
            this.writeNode(generator, e.getValue());
        }
        generator.writeEndObject();
    }

    private void writeArray(JsonGenerator generator, ArrayNode arrayNode) throws IOException {
        generator.writeStartArray();
        for (Node item : arrayNode) {
            this.writeNode(generator, item);
        }
        generator.writeEndArray();
    }

    private void writeScalar(JsonGenerator generator, Node node) throws IOException {
        Node node2 = node;
        Objects.requireNonNull(node2);
        Node node3 = node2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TextNode.class, IntNode.class, LongNode.class, FloatNode.class, DoubleNode.class, BigIntegerNode.class, BigDecimalNode.class, BooleanNode.class, NullNode.class}, (Node)node3, n)) {
            case 0: {
                TextNode textNode = (TextNode)node3;
                generator.writeString(textNode.value());
                break;
            }
            case 1: {
                IntNode intNode = (IntNode)node3;
                generator.writeNumber(intNode.value());
                break;
            }
            case 2: {
                LongNode longNode = (LongNode)node3;
                generator.writeNumber(longNode.value());
                break;
            }
            case 3: {
                FloatNode floatNode = (FloatNode)node3;
                generator.writeNumber(floatNode.value());
                break;
            }
            case 4: {
                DoubleNode doubleNode = (DoubleNode)node3;
                generator.writeNumber(doubleNode.value());
                break;
            }
            case 5: {
                BigIntegerNode bigIntegerNode = (BigIntegerNode)node3;
                generator.writeNumber(bigIntegerNode.value());
                break;
            }
            case 6: {
                BigDecimalNode bigDecimalNode = (BigDecimalNode)node3;
                generator.writeNumber(bigDecimalNode.value());
                break;
            }
            case 7: {
                BooleanNode booleanNode = (BooleanNode)node3;
                generator.writeBoolean(booleanNode.value());
                break;
            }
            case 8: {
                generator.writeNull();
                break;
            }
            default: {
                throw new IOException("Unsupported Node Type: " + node.getClass().getName());
            }
        }
    }
}

