/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapping.mapper;

import cool.scx.object.mapping.FromNodeContext;
import cool.scx.object.mapping.NodeMapper;
import cool.scx.object.mapping.NodeMappingException;
import cool.scx.object.mapping.ToNodeContext;
import cool.scx.object.node.ArrayNode;
import cool.scx.object.node.Node;
import cool.scx.reflect.ArrayTypeInfo;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public final class ArrayNodeMapper
implements NodeMapper<Object> {
    private final ArrayTypeInfo arrayTypeInfo;
    private final NodeMapper<Object> componentNodeMapper;

    public ArrayNodeMapper(ArrayTypeInfo arrayTypeInfo, NodeMapper<Object> componentNodeMapper) {
        this.arrayTypeInfo = arrayTypeInfo;
        this.componentNodeMapper = componentNodeMapper;
    }

    @Override
    public Node toNode(Object value, ToNodeContext context) throws NodeMappingException {
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Object[].class, byte[].class, short[].class, int[].class, long[].class, float[].class, double[].class, boolean[].class, char[].class}, (Object)object2, n)) {
            case 0: {
                Object[] arr = (Object[])object2;
                ArrayNode arrayNode = new ArrayNode(arr.length);
                int i = 0;
                for (Object a : arr) {
                    arrayNode.add(context.toNode(a, i));
                    ++i;
                }
                return arrayNode;
            }
            case 1: {
                byte[] arr = (byte[])object2;
                ArrayNode arrayNode = new ArrayNode(arr.length);
                for (byte a : arr) {
                    arrayNode.add(this.componentNodeMapper.toNode(a, context));
                }
                return arrayNode;
            }
            case 2: {
                short[] arr = (short[])object2;
                ArrayNode arrayNode = new ArrayNode(arr.length);
                for (short a : arr) {
                    arrayNode.add(this.componentNodeMapper.toNode(a, context));
                }
                return arrayNode;
            }
            case 3: {
                int[] arr = (int[])object2;
                ArrayNode arrayNode = new ArrayNode(arr.length);
                for (int a : arr) {
                    arrayNode.add(this.componentNodeMapper.toNode(a, context));
                }
                return arrayNode;
            }
            case 4: {
                long[] arr = (long[])object2;
                ArrayNode arrayNode = new ArrayNode(arr.length);
                for (long a : arr) {
                    arrayNode.add(this.componentNodeMapper.toNode(a, context));
                }
                return arrayNode;
            }
            case 5: {
                float[] arr = (float[])object2;
                ArrayNode arrayNode = new ArrayNode(arr.length);
                for (float a : arr) {
                    arrayNode.add(this.componentNodeMapper.toNode(Float.valueOf(a), context));
                }
                return arrayNode;
            }
            case 6: {
                double[] arr = (double[])object2;
                ArrayNode arrayNode = new ArrayNode(arr.length);
                for (double a : arr) {
                    arrayNode.add(this.componentNodeMapper.toNode(a, context));
                }
                return arrayNode;
            }
            case 7: {
                boolean[] arr = (boolean[])object2;
                ArrayNode arrayNode = new ArrayNode(arr.length);
                for (boolean a : arr) {
                    arrayNode.add(this.componentNodeMapper.toNode(a, context));
                }
                return arrayNode;
            }
            case 8: {
                char[] arr = (char[])object2;
                ArrayNode arrayNode = new ArrayNode(arr.length);
                for (char a : arr) {
                    arrayNode.add(this.componentNodeMapper.toNode(Character.valueOf(a), context));
                }
                return arrayNode;
            }
        }
        throw new NodeMappingException("Unsupported type: " + String.valueOf(value.getClass()));
    }

    @Override
    public Object fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        Object array;
        if (node.isNull()) {
            return null;
        }
        if (node instanceof ArrayNode) {
            Object array2;
            ArrayNode arrayNode = (ArrayNode)node;
            Object object = array2 = this.arrayTypeInfo.newArray(arrayNode.size());
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Object[].class, byte[].class, short[].class, int[].class, long[].class, float[].class, double[].class, boolean[].class, char[].class}, (Object)object2, n)) {
                case 0: {
                    Object[] result = (Object[])object2;
                    int i = 0;
                    for (Node e : arrayNode) {
                        result[i] = this.componentNodeMapper.fromNode(e, context);
                        ++i;
                    }
                    return result;
                }
                case 1: {
                    byte[] result = (byte[])object2;
                    int i = 0;
                    for (Node e : arrayNode) {
                        result[i] = (Byte)this.componentNodeMapper.fromNode(e, context);
                        ++i;
                    }
                    return result;
                }
                case 2: {
                    short[] result = (short[])object2;
                    int i = 0;
                    for (Node e : arrayNode) {
                        result[i] = (Short)this.componentNodeMapper.fromNode(e, context);
                        ++i;
                    }
                    return result;
                }
                case 3: {
                    int[] result = (int[])object2;
                    int i = 0;
                    for (Node e : arrayNode) {
                        result[i] = (Integer)this.componentNodeMapper.fromNode(e, context);
                        ++i;
                    }
                    return result;
                }
                case 4: {
                    long[] result = (long[])object2;
                    int i = 0;
                    for (Node e : arrayNode) {
                        result[i] = (Long)this.componentNodeMapper.fromNode(e, context);
                        ++i;
                    }
                    return result;
                }
                case 5: {
                    float[] result = (float[])object2;
                    int i = 0;
                    for (Node e : arrayNode) {
                        result[i] = ((Float)this.componentNodeMapper.fromNode(e, context)).floatValue();
                        ++i;
                    }
                    return result;
                }
                case 6: {
                    double[] result = (double[])object2;
                    int i = 0;
                    for (Node e : arrayNode) {
                        result[i] = (Double)this.componentNodeMapper.fromNode(e, context);
                        ++i;
                    }
                    return result;
                }
                case 7: {
                    boolean[] result = (boolean[])object2;
                    int i = 0;
                    for (Node e : arrayNode) {
                        result[i] = (Boolean)this.componentNodeMapper.fromNode(e, context);
                        ++i;
                    }
                    return result;
                }
                case 8: {
                    char[] result = (char[])object2;
                    int i = 0;
                    for (Node e : arrayNode) {
                        result[i] = ((Character)this.componentNodeMapper.fromNode(e, context)).charValue();
                        ++i;
                    }
                    return result;
                }
            }
            throw new NodeMappingException("Unsupported type: " + String.valueOf(array2.getClass()));
        }
        Object object = array = this.arrayTypeInfo.newArray(1);
        Objects.requireNonNull(object);
        Object object3 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Object[].class, byte[].class, short[].class, int[].class, long[].class, float[].class, double[].class, boolean[].class, char[].class}, (Object)object3, n)) {
            case 0: {
                Object[] result = (Object[])object3;
                result[0] = this.componentNodeMapper.fromNode(node, context);
                return result;
            }
            case 1: {
                byte[] result = (byte[])object3;
                result[0] = (Byte)this.componentNodeMapper.fromNode(node, context);
                return result;
            }
            case 2: {
                short[] result = (short[])object3;
                result[0] = (Short)this.componentNodeMapper.fromNode(node, context);
                return result;
            }
            case 3: {
                int[] result = (int[])object3;
                result[0] = (Integer)this.componentNodeMapper.fromNode(node, context);
                return result;
            }
            case 4: {
                long[] result = (long[])object3;
                result[0] = (Long)this.componentNodeMapper.fromNode(node, context);
                return result;
            }
            case 5: {
                float[] result = (float[])object3;
                result[0] = ((Float)this.componentNodeMapper.fromNode(node, context)).floatValue();
                return result;
            }
            case 6: {
                double[] result = (double[])object3;
                result[0] = (Double)this.componentNodeMapper.fromNode(node, context);
                return result;
            }
            case 7: {
                boolean[] result = (boolean[])object3;
                result[0] = (Boolean)this.componentNodeMapper.fromNode(node, context);
                return result;
            }
            case 8: {
                char[] result = (char[])object3;
                result[0] = ((Character)this.componentNodeMapper.fromNode(node, context)).charValue();
                return result;
            }
        }
        throw new NodeMappingException("Unsupported type: " + String.valueOf(array.getClass()));
    }
}

