/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapping.mapper.math;

import cool.scx.object.mapping.FromNodeContext;
import cool.scx.object.mapping.NodeMapper;
import cool.scx.object.mapping.NodeMappingException;
import cool.scx.object.mapping.ToNodeContext;
import cool.scx.object.node.ArrayNode;
import cool.scx.object.node.BigIntegerNode;
import cool.scx.object.node.Node;
import cool.scx.object.node.ValueNode;
import java.math.BigInteger;

public final class BigIntegerNodeMapper
implements NodeMapper<BigInteger> {
    @Override
    public Node toNode(BigInteger value, ToNodeContext context) {
        return new BigIntegerNode(value);
    }

    @Override
    public BigInteger fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        ArrayNode arrayNode;
        if (node.isNull()) {
            return null;
        }
        if (node instanceof ValueNode) {
            ValueNode valueNode = (ValueNode)node;
            try {
                return valueNode.asBigInteger();
            }
            catch (NumberFormatException e) {
                throw new NodeMappingException(e);
            }
        }
        if (node instanceof ArrayNode && (arrayNode = (ArrayNode)node).size() == 1) {
            return this.fromNode(arrayNode.get(0), context);
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }
}

