/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapping.mapper.node;

import cool.scx.object.mapping.FromNodeContext;
import cool.scx.object.mapping.NodeMapper;
import cool.scx.object.mapping.NodeMappingException;
import cool.scx.object.mapping.ToNodeContext;
import cool.scx.object.node.BigIntegerNode;
import cool.scx.object.node.Node;
import cool.scx.object.node.ValueNode;

public final class BigIntegerNodeNodeMapper
implements NodeMapper<BigIntegerNode> {
    @Override
    public Node toNode(BigIntegerNode value, ToNodeContext context) {
        return value.deepCopy();
    }

    @Override
    public BigIntegerNode fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        if (node.isNull()) {
            return null;
        }
        if (node instanceof BigIntegerNode) {
            BigIntegerNode bigIntegerNode = (BigIntegerNode)node;
            return bigIntegerNode.deepCopy();
        }
        if (node instanceof ValueNode) {
            ValueNode valueNode = (ValueNode)node;
            try {
                return new BigIntegerNode(valueNode.asBigInteger());
            }
            catch (NumberFormatException e) {
                throw new NodeMappingException(e);
            }
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }
}

