/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapping.mapper.node;

import cool.scx.object.mapping.FromNodeContext;
import cool.scx.object.mapping.NodeMapper;
import cool.scx.object.mapping.NodeMappingException;
import cool.scx.object.mapping.ToNodeContext;
import cool.scx.object.node.IntNode;
import cool.scx.object.node.Node;
import cool.scx.object.node.ValueNode;

public final class IntNodeNodeMapper
implements NodeMapper<IntNode> {
    @Override
    public Node toNode(IntNode value, ToNodeContext context) {
        return value.deepCopy();
    }

    @Override
    public IntNode fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        if (node.isNull()) {
            return null;
        }
        if (node instanceof IntNode) {
            IntNode intNode = (IntNode)node;
            return intNode.deepCopy();
        }
        if (node instanceof ValueNode) {
            ValueNode valueNode = (ValueNode)node;
            try {
                return new IntNode(valueNode.asInt());
            }
            catch (NumberFormatException e) {
                throw new NodeMappingException(e);
            }
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }
}

