/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapping.mapper.record;

import cool.scx.object.mapping.FromNodeContext;
import cool.scx.object.mapping.NodeMapper;
import cool.scx.object.mapping.NodeMappingException;
import cool.scx.object.mapping.ToNodeContext;
import cool.scx.object.mapping.mapper.record.RecordNodeMapperOptions;
import cool.scx.object.node.ArrayNode;
import cool.scx.object.node.Node;
import cool.scx.object.node.NullNode;
import cool.scx.object.node.ObjectNode;
import cool.scx.reflect.ClassInfo;
import cool.scx.reflect.ConstructorInfo;
import cool.scx.reflect.ParameterInfo;
import cool.scx.reflect.RecordComponentInfo;
import java.lang.reflect.InvocationTargetException;

public final class RecordNodeMapper
implements NodeMapper<Record> {
    private static final RecordNodeMapperOptions RECORD_NODE_MAPPER_OPTIONS = new RecordNodeMapperOptions();
    private final ClassInfo classInfo;
    private final RecordComponentInfo[] recordComponents;
    private final ConstructorInfo recordConstructor;
    private final ParameterInfo[] parameters;

    public RecordNodeMapper(ClassInfo classInfo) {
        this.classInfo = classInfo;
        this.recordComponents = this.classInfo.recordComponents();
        this.recordConstructor = this.classInfo.recordConstructor();
        this.parameters = this.recordConstructor.parameters();
    }

    private static Object getComponentValue(RecordComponentInfo componentInfo, Object value) throws NodeMappingException {
        try {
            return componentInfo.get(value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new NodeMappingException(e);
        }
    }

    @Override
    public Node toNode(Record recordValue, ToNodeContext context) throws NodeMappingException {
        RecordNodeMapperOptions options = context.options().getMapperOptions(RecordNodeMapperOptions.class, RECORD_NODE_MAPPER_OPTIONS);
        ObjectNode objectNode = new ObjectNode();
        for (RecordComponentInfo recordComponent : this.recordComponents) {
            String name = recordComponent.name();
            Object value = RecordNodeMapper.getComponentValue(recordComponent, recordValue);
            if (value == null && options.ignoreNullValue()) continue;
            objectNode.put(name, context.toNode(value, name));
        }
        return objectNode;
    }

    @Override
    public Record fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        ArrayNode arrayNode;
        if (node.isNull()) {
            return null;
        }
        if (node instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)node;
            Object[] params = new Object[this.parameters.length];
            for (int i = 0; i < this.parameters.length; ++i) {
                ParameterInfo parameter = this.parameters[i];
                Node tempNode = objectNode.get(parameter.name());
                if (tempNode == null) {
                    tempNode = NullNode.NULL;
                }
                params[i] = context.fromNode(tempNode, parameter.parameterType());
            }
            return this.newInstance(params);
        }
        if (node instanceof ArrayNode && (arrayNode = (ArrayNode)node).size() == 1) {
            return this.fromNode(arrayNode.get(0), context);
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }

    public ClassInfo classInfo() {
        return this.classInfo;
    }

    private Record newInstance(Object ... params) throws NodeMappingException {
        try {
            return (Record)this.recordConstructor.newInstance(params);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new NodeMappingException(e);
        }
    }
}

