/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.node;

import cool.scx.object.node.NumberNode;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class BigDecimalNode
implements NumberNode {
    private final BigDecimal _value;

    public BigDecimalNode(BigDecimal v) {
        if (v == null) {
            throw new NullPointerException("BigDecimalNode value cannot be null");
        }
        this._value = v;
    }

    public BigDecimal value() {
        return this._value;
    }

    @Override
    public int asInt() {
        return this._value.intValue();
    }

    @Override
    public long asLong() {
        return this._value.longValue();
    }

    @Override
    public float asFloat() {
        return this._value.floatValue();
    }

    @Override
    public double asDouble() {
        return this._value.doubleValue();
    }

    @Override
    public BigInteger asBigInteger() {
        return this._value.toBigInteger();
    }

    @Override
    public BigDecimal asBigDecimal() {
        return this._value;
    }

    @Override
    public String asText() {
        return this._value.toString();
    }

    @Override
    public boolean asBoolean() {
        return !this._value.equals(BigDecimal.ZERO);
    }

    @Override
    public BigDecimalNode deepCopy() {
        return this;
    }

    public boolean equals(Object object) {
        if (object instanceof BigDecimalNode) {
            BigDecimalNode bigDecimalNode = (BigDecimalNode)object;
            return this._value.equals(bigDecimalNode._value);
        }
        return false;
    }

    public int hashCode() {
        return this._value.hashCode();
    }

    public String toString() {
        return this.asText();
    }
}

