/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.parser.xml;

import com.ctc.wstx.stax.WstxInputFactory;
import cool.scx.object.node.ArrayNode;
import cool.scx.object.node.Node;
import cool.scx.object.node.NullNode;
import cool.scx.object.node.ObjectNode;
import cool.scx.object.node.TextNode;
import cool.scx.object.parser.NodeParseException;
import cool.scx.object.parser.NodeParser;
import cool.scx.object.parser.xml.AutoCloseableXMLStreamReader;
import cool.scx.object.parser.xml.XmlNodeParserOptions;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax2.XMLStreamReader2;

public class XmlNodeParser
implements NodeParser {
    private final WstxInputFactory xmlFactory;
    private final XmlNodeParserOptions options;

    public XmlNodeParser(WstxInputFactory xmlFactory, XmlNodeParserOptions options) {
        this.xmlFactory = xmlFactory;
        this.options = options;
        this.xmlFactory.setProperty("com.ctc.wstx.maxElementDepth", (Object)options.maxNestingDepth());
        this.xmlFactory.setProperty("com.ctc.wstx.maxTextLength", (Object)options.maxStringLength());
        this.xmlFactory.setProperty("com.ctc.wstx.maxAttributeSize", (Object)options.maxStringLength());
        this.xmlFactory.setProperty("com.ctc.wstx.maxChildrenPerElement", (Object)options.maxChildCount());
        this.xmlFactory.setProperty("com.ctc.wstx.maxAttributesPerElement", (Object)options.maxChildCount());
        this.xmlFactory.setProperty("javax.xml.stream.supportDTD", (Object)false);
        this.xmlFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", (Object)false);
    }

    @Override
    public Node parse(String xml) throws NodeParseException {
        Node node;
        block8: {
            AutoCloseableXMLStreamReader xmlStreamReader = AutoCloseableXMLStreamReader.wrap(this.xmlFactory.createXMLStreamReader((Reader)new StringReader(xml)));
            try {
                node = this.parse(xmlStreamReader.reader());
                if (xmlStreamReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (xmlStreamReader != null) {
                        try {
                            xmlStreamReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (XMLStreamException e) {
                    throw new NodeParseException(e);
                }
            }
            xmlStreamReader.close();
        }
        return node;
    }

    @Override
    public Node parse(File file) throws NodeParseException {
        Node node;
        block8: {
            AutoCloseableXMLStreamReader xmlStreamReader = AutoCloseableXMLStreamReader.wrap((XMLStreamReader)this.xmlFactory.createXMLStreamReader(file));
            try {
                node = this.parse(xmlStreamReader.reader());
                if (xmlStreamReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (xmlStreamReader != null) {
                        try {
                            xmlStreamReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (XMLStreamException e) {
                    throw new NodeParseException(e);
                }
            }
            xmlStreamReader.close();
        }
        return node;
    }

    private Node parse(XMLStreamReader2 reader) throws XMLStreamException {
        int eventType;
        while ((eventType = reader.getEventType()) != 1) {
            reader.next();
        }
        Node node = this.parseElement(reader);
        while (reader.hasNext()) {
            reader.next();
        }
        return node;
    }

    private Node parseElement(XMLStreamReader2 reader) throws XMLStreamException {
        ObjectNode elements = new ObjectNode();
        int attributeCount = reader.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            String name = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            Node oldChildNode = elements.get(name);
            if (oldChildNode == null) {
                elements.put(name, new TextNode(value));
                continue;
            }
            if (oldChildNode instanceof ArrayNode) {
                ArrayNode arrayNode = (ArrayNode)oldChildNode;
                arrayNode.add(new TextNode(value));
                continue;
            }
            ArrayNode arrayNode = new ArrayNode();
            arrayNode.add(oldChildNode);
            arrayNode.add(new TextNode(value));
            elements.put(name, arrayNode);
        }
        boolean emptyElement = reader.isEmptyElement();
        if (emptyElement) {
            reader.next();
            if (elements.isEmpty()) {
                return NullNode.NULL;
            }
            return elements;
        }
        ArrayNode texts = new ArrayNode();
        while (true) {
            int eventType;
            if ((eventType = reader.next()) == 1) {
                String name = reader.getLocalName();
                Node element = this.parseElement(reader);
                Node oldChildNode = elements.get(name);
                if (oldChildNode == null) {
                    elements.put(name, element);
                    continue;
                }
                if (oldChildNode instanceof ArrayNode) {
                    ArrayNode arrayNode = (ArrayNode)oldChildNode;
                    arrayNode.add(element);
                    continue;
                }
                ArrayNode arrayNode = new ArrayNode();
                arrayNode.add(oldChildNode);
                arrayNode.add(element);
                elements.put(name, arrayNode);
                continue;
            }
            if (eventType == 4) {
                String text = reader.getText();
                if (text.isBlank()) continue;
                texts.add(new TextNode(text));
                continue;
            }
            if (eventType == 2) break;
        }
        if (elements.isEmpty()) {
            if (texts.isEmpty()) {
                return new TextNode("");
            }
            if (texts.size() == 1) {
                return texts.get(0);
            }
            return texts;
        }
        if (texts.size() == 1) {
            elements.put("", texts.get(0));
            return elements;
        }
        if (texts.size() > 1) {
            elements.put("", texts);
        }
        return elements;
    }
}

