/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object;

import cool.scx.object.ScxObject;
import cool.scx.object.mapping.NodeMappingException;
import cool.scx.object.node.ArrayNode;
import cool.scx.object.node.Node;
import cool.scx.object.node.ObjectNode;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;

public class NodeHelper {
    /*
     * Enabled aggressive block sorting
     */
    public static void merge(Node target, Node source) {
        if (target instanceof ObjectNode) {
            ObjectNode targetObj = (ObjectNode)target;
            if (source instanceof ObjectNode) {
                ObjectNode sourceObj = (ObjectNode)source;
                NodeHelper.mergeObjectNode(targetObj, sourceObj);
                return;
            }
        }
        if (!(target instanceof ArrayNode)) throw new IllegalArgumentException("Cannot merge nodes of type: " + String.valueOf(target.getClass()) + " and " + String.valueOf(source.getClass()));
        ArrayNode targetArr = (ArrayNode)target;
        if (!(source instanceof ArrayNode)) throw new IllegalArgumentException("Cannot merge nodes of type: " + String.valueOf(target.getClass()) + " and " + String.valueOf(source.getClass()));
        ArrayNode sourceArr = (ArrayNode)source;
        NodeHelper.mergeArrayNode(targetArr, sourceArr);
    }

    private static void mergeObjectNode(ObjectNode target, ObjectNode source) {
        for (Map.Entry<String, Node> entry : source) {
            String key = entry.getKey();
            Node sourceNode = entry.getValue();
            Node targetNode = target.get(key);
            if (targetNode instanceof ObjectNode && sourceNode instanceof ObjectNode) {
                NodeHelper.merge(targetNode, sourceNode);
                continue;
            }
            if (targetNode instanceof ArrayNode && sourceNode instanceof ArrayNode) {
                NodeHelper.merge(targetNode, sourceNode);
                continue;
            }
            target.put(key, sourceNode);
        }
    }

    private static void mergeArrayNode(ArrayNode target, ArrayNode source) {
        for (Node node : source) {
            target.add(node);
        }
    }

    public static Node get(Node jsonNode, String jsonPath) {
        String[] paths = jsonPath.split("\\.");
        Node result = jsonNode;
        for (String path : paths) {
            if (result == null) break;
            if (result instanceof ObjectNode) {
                ObjectNode i = (ObjectNode)result;
                result = i.get(path);
                continue;
            }
            result = null;
        }
        return result;
    }

    public static Node set(ObjectNode objectNode, String jsonPath, Object object) throws NodeMappingException {
        String[] paths = jsonPath.split("\\.");
        ObjectNode jsonNode = objectNode;
        for (int i = 0; i < paths.length; ++i) {
            Node n;
            String path = paths[i];
            if (i == paths.length - 1) {
                NodeHelper.put(jsonNode, path, object);
                continue;
            }
            Node node = n = jsonNode.get(path);
            int n2 = 0;
            jsonNode = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ObjectNode.class}, (Node)node, n2)) {
                case -1 -> {
                    ObjectNode entries = new ObjectNode();
                    jsonNode.put(path, entries);
                    yield entries;
                }
                case 0 -> {
                    ObjectNode nn;
                    yield nn = (ObjectNode)node;
                }
                default -> throw new RuntimeException("\u8def\u5f84\u4e2d\u5df2\u6709\u6570\u636e\u4e14\u4e0d\u4e3a Object, \u65e0\u6cd5 set");
            };
        }
        return objectNode;
    }

    private static void put(ObjectNode objectNode, String fieldName, Object object) throws NodeMappingException {
        objectNode.put(fieldName, ScxObject.convertValue(object, Node.class));
    }
}

