/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapping.mapper;

import cool.scx.object.mapping.FromNodeContext;
import cool.scx.object.mapping.NodeMapper;
import cool.scx.object.mapping.NodeMappingException;
import cool.scx.object.mapping.ToNodeContext;
import cool.scx.object.node.ArrayNode;
import cool.scx.object.node.Node;
import cool.scx.object.node.TextNode;

public final class EnumNodeMapper<E extends Enum<E>>
implements NodeMapper<E> {
    private final Class<E> enumClass;

    public EnumNodeMapper(Class<E> enumClass) {
        this.enumClass = enumClass;
    }

    @Override
    public Node toNode(E value, ToNodeContext context) {
        return new TextNode(((Enum)value).name());
    }

    @Override
    public E fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        ArrayNode arrayNode;
        if (node.isNull()) {
            return null;
        }
        if (node instanceof TextNode) {
            TextNode textNode = (TextNode)node;
            String value = textNode.value();
            try {
                return Enum.valueOf(this.enumClass, value);
            }
            catch (IllegalArgumentException e) {
                throw new NodeMappingException(e);
            }
        }
        if (node instanceof ArrayNode && (arrayNode = (ArrayNode)node).size() == 1) {
            return (E)this.fromNode(arrayNode.get(0), context);
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }
}

