/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapping.mapper.map;

import cool.scx.object.mapping.FromNodeContext;
import cool.scx.object.mapping.NodeMapper;
import cool.scx.object.mapping.NodeMappingException;
import cool.scx.object.mapping.ToNodeContext;
import cool.scx.object.mapping.mapper.map.MapNodeMapperOptions;
import cool.scx.object.node.ArrayNode;
import cool.scx.object.node.Node;
import cool.scx.object.node.ObjectNode;
import cool.scx.object.node.TextNode;
import cool.scx.object.node.ValueNode;
import cool.scx.reflect.ClassInfo;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

public final class MapNodeMapper
implements NodeMapper<Map<?, ?>> {
    private static final MapNodeMapperOptions MAP_NODE_MAPPER_OPTIONS = new MapNodeMapperOptions();
    private final ClassInfo classInfo;
    private final NodeMapper<Object> keyNodeMapper;
    private final NodeMapper<Object> valueNodeMapper;

    public MapNodeMapper(ClassInfo classInfo, NodeMapper<Object> keyNodeMapper, NodeMapper<Object> valueNodeMapper) {
        this.classInfo = classInfo;
        this.keyNodeMapper = keyNodeMapper;
        this.valueNodeMapper = valueNodeMapper;
    }

    @Override
    public Node toNode(Map<?, ?> mapValue, ToNodeContext context) throws NodeMappingException {
        MapNodeMapperOptions options = context.options().getMapperOptions(MapNodeMapperOptions.class, MAP_NODE_MAPPER_OPTIONS);
        ObjectNode objectNode = new ObjectNode(mapValue.size());
        for (Map.Entry<?, ?> e : mapValue.entrySet()) {
            Object key = e.getKey();
            Object value = e.getValue();
            if (value == null && options.ignoreNullValue()) continue;
            String k = this.toKey(key, context, options);
            Node v = context.toNode(value, k);
            objectNode.put(k, v);
        }
        return objectNode;
    }

    @Override
    public Map<?, ?> fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        ArrayNode arrayNode;
        if (node.isNull()) {
            return null;
        }
        if (node instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)node;
            Map<Object, Object> result = this.createMap(objectNode.size());
            for (Map.Entry<String, Node> n : objectNode) {
                Object k = this.keyNodeMapper.fromNode(new TextNode(n.getKey()), context);
                Object v = this.valueNodeMapper.fromNode(n.getValue(), context);
                result.put(k, v);
            }
            return result;
        }
        if (node instanceof ArrayNode && (arrayNode = (ArrayNode)node).size() == 1) {
            return this.fromNode(arrayNode.get(0), context);
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }

    private String toKey(Object value, ToNodeContext context, MapNodeMapperOptions options) throws NodeMappingException {
        Node node = context.toNode(value, null);
        if (node.isNull()) {
            return options.nullKey();
        }
        if (node instanceof ValueNode) {
            ValueNode valueNode = (ValueNode)node;
            return valueNode.asText();
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }

    private Map<Object, Object> createMap(int size) throws NodeMappingException {
        if (this.classInfo.rawClass() == Map.class) {
            return new LinkedHashMap<Object, Object>(size);
        }
        if (this.classInfo.rawClass() == HashMap.class) {
            return new HashMap<Object, Object>(size);
        }
        if (this.classInfo.rawClass() == LinkedHashMap.class) {
            return new LinkedHashMap<Object, Object>(size);
        }
        if (this.classInfo.rawClass() == TreeMap.class) {
            return new TreeMap<Object, Object>();
        }
        if (this.classInfo.rawClass() == ConcurrentHashMap.class) {
            return new ConcurrentHashMap<Object, Object>(size);
        }
        throw new NodeMappingException("Unsupported Map type: " + String.valueOf(this.classInfo));
    }
}

