/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapping.mapper.time;

import cool.scx.object.mapping.FromNodeContext;
import cool.scx.object.mapping.NodeMapper;
import cool.scx.object.mapping.NodeMappingException;
import cool.scx.object.mapping.ToNodeContext;
import cool.scx.object.node.ArrayNode;
import cool.scx.object.node.Node;
import cool.scx.object.node.TextNode;
import java.time.Duration;
import java.time.format.DateTimeParseException;

public final class DurationNodeMapper
implements NodeMapper<Duration> {
    @Override
    public Node toNode(Duration value, ToNodeContext context) {
        return new TextNode(value.toString());
    }

    @Override
    public Duration fromNode(Node node, FromNodeContext context) throws NodeMappingException {
        ArrayNode arrayNode;
        if (node.isNull()) {
            return null;
        }
        if (node instanceof TextNode) {
            TextNode textNode = (TextNode)node;
            try {
                return Duration.parse(textNode.asText());
            }
            catch (DateTimeParseException e) {
                throw new NodeMappingException(e);
            }
        }
        if (node instanceof ArrayNode && (arrayNode = (ArrayNode)node).size() == 1) {
            return this.fromNode(arrayNode.get(0), context);
        }
        throw new NodeMappingException("Unsupported node type: " + String.valueOf(node.getClass()));
    }
}

