/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.mapping.mapper_factory;

import cool.scx.object.mapping.NodeMapper;
import cool.scx.object.mapping.NodeMapperFactory;
import cool.scx.object.mapping.NodeMapperSelector;
import cool.scx.object.mapping.mapper.bean.BeanNodeMapper;
import cool.scx.reflect.AccessModifier;
import cool.scx.reflect.ClassInfo;
import cool.scx.reflect.ClassKind;
import cool.scx.reflect.ConstructorInfo;
import cool.scx.reflect.FieldInfo;
import cool.scx.reflect.TypeInfo;
import java.util.Arrays;

public class BeanNodeMapperFactory
implements NodeMapperFactory {
    private static FieldInfo[] filterReadableFields(ClassInfo classInfo) {
        return (FieldInfo[])Arrays.stream(classInfo.allFields()).filter(c -> !c.isStatic() && c.accessModifier() == AccessModifier.PUBLIC).peek(c -> c.setAccessible(true)).toArray(FieldInfo[]::new);
    }

    private static FieldInfo[] filterWritableFields(FieldInfo[] readableFields) {
        return (FieldInfo[])Arrays.stream(readableFields).filter(c -> !c.isFinal()).toArray(FieldInfo[]::new);
    }

    @Override
    public NodeMapper<?> createNodeMapper(TypeInfo typeInfo, NodeMapperSelector selector) {
        ClassInfo classInfo;
        if (typeInfo instanceof ClassInfo && (classInfo = (ClassInfo)typeInfo).classKind() == ClassKind.CLASS && !classInfo.isAbstract()) {
            ConstructorInfo defaultConstructor = classInfo.defaultConstructor();
            FieldInfo[] readableFields = BeanNodeMapperFactory.filterReadableFields(classInfo);
            FieldInfo[] writableFields = BeanNodeMapperFactory.filterWritableFields(readableFields);
            return new BeanNodeMapper(classInfo, defaultConstructor, readableFields, writableFields);
        }
        return null;
    }
}

