/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.node;

import cool.scx.object.node.Node;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class ArrayNode
implements Node,
Iterable<Node> {
    private final List<Node> _children;

    public ArrayNode() {
        this._children = new ArrayList<Node>();
    }

    public ArrayNode(int initialCapacity) {
        this._children = new ArrayList<Node>(initialCapacity);
    }

    public void add(Node node) {
        if (node == null) {
            throw new NullPointerException("ArrayNode cannot add null");
        }
        this._children.add(node);
    }

    public void add(int index, Node node) {
        if (node == null) {
            throw new NullPointerException("ArrayNode cannot add null");
        }
        this._children.add(index, node);
    }

    public void set(int index, Node node) {
        if (node == null) {
            throw new NullPointerException("ArrayNode cannot set null");
        }
        this._children.set(index, node);
    }

    public Node get(int index) {
        return this._children.get(index);
    }

    public Node remove(int index) {
        return this._children.remove(index);
    }

    public int size() {
        return this._children.size();
    }

    public boolean isEmpty() {
        return this._children.isEmpty();
    }

    @Override
    public Iterator<Node> iterator() {
        return this._children.iterator();
    }

    @Override
    public ArrayNode deepCopy() {
        ArrayNode arrayNode = new ArrayNode(this.size());
        for (Node node : this) {
            arrayNode.add(node.deepCopy());
        }
        return arrayNode;
    }

    public boolean equals(Object object) {
        if (object instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)object;
            return this._children.equals(arrayNode._children);
        }
        return false;
    }

    public int hashCode() {
        return this._children.hashCode();
    }

    public String toString() {
        return this._children.toString();
    }
}

