/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.node;

import cool.scx.object.node.NumberNode;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class DoubleNode
implements NumberNode {
    private final double _value;

    public DoubleNode(double v) {
        this._value = v;
    }

    public double value() {
        return this._value;
    }

    @Override
    public int asInt() {
        return (int)this._value;
    }

    @Override
    public long asLong() {
        return (long)this._value;
    }

    @Override
    public float asFloat() {
        return (float)this._value;
    }

    @Override
    public double asDouble() {
        return this._value;
    }

    @Override
    public BigInteger asBigInteger() {
        return BigDecimal.valueOf(this._value).toBigInteger();
    }

    @Override
    public BigDecimal asBigDecimal() {
        return BigDecimal.valueOf(this._value);
    }

    @Override
    public String asText() {
        return String.valueOf(this._value);
    }

    @Override
    public boolean asBoolean() {
        return this._value != 0.0;
    }

    @Override
    public DoubleNode deepCopy() {
        return this;
    }

    public boolean equals(Object object) {
        if (object instanceof DoubleNode) {
            DoubleNode doubleNode = (DoubleNode)object;
            return Double.compare(this._value, doubleNode._value) == 0;
        }
        return false;
    }

    public int hashCode() {
        return Double.hashCode(this._value);
    }

    public String toString() {
        return this.asText();
    }
}

