/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.object.serializer.xml;

import com.ctc.wstx.stax.WstxOutputFactory;
import cool.scx.object.node.ArrayNode;
import cool.scx.object.node.Node;
import cool.scx.object.node.NullNode;
import cool.scx.object.node.ObjectNode;
import cool.scx.object.node.ValueNode;
import cool.scx.object.serializer.NodeSerializeException;
import cool.scx.object.serializer.NodeSerializer;
import cool.scx.object.serializer.xml.AutoCloseableXMLStreamWriter;
import cool.scx.object.serializer.xml.XmlNodeSerializerOptions;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamWriter2;

public final class XmlNodeSerializer
implements NodeSerializer {
    private final WstxOutputFactory xmlFactory;
    private final XmlNodeSerializerOptions options;

    public XmlNodeSerializer(WstxOutputFactory xmlFactory, XmlNodeSerializerOptions options) {
        this.xmlFactory = xmlFactory;
        this.options = options;
    }

    @Override
    public String serializeAsString(Node node) throws NodeSerializeException {
        StringWriter writer = new StringWriter();
        try (AutoCloseableXMLStreamWriter xmlStreamWriter = AutoCloseableXMLStreamWriter.wrap(this.xmlFactory.createXMLStreamWriter((Writer)writer));){
            this.serialize(xmlStreamWriter.writer(), node);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }

    private void serialize(XMLStreamWriter2 writer2, Node node) throws XMLStreamException {
        boolean isRootArray = node instanceof ArrayNode;
        this.writeNode(writer2, node, this.options.rootName(), isRootArray, 1);
    }

    private void writeNode(XMLStreamWriter2 writer2, Node node, String key, boolean inArray, int currentDepth) throws XMLStreamException {
        if (currentDepth > this.options.maxNestingDepth()) {
            throw new NodeSerializeException("Nesting depth exceeds limit: " + this.options.maxNestingDepth());
        }
        Node node2 = node;
        Objects.requireNonNull(node2);
        Node node3 = node2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NullNode.class, ValueNode.class, ObjectNode.class, ArrayNode.class}, (Node)node3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                writer2.writeEmptyElement(key);
                break;
            }
            case 1: {
                ValueNode valueNode = (ValueNode)node3;
                if (key.isEmpty()) {
                    writer2.writeCharacters(valueNode.toString());
                    break;
                }
                writer2.writeStartElement(key);
                writer2.writeCharacters(valueNode.toString());
                writer2.writeEndElement();
                break;
            }
            case 2: {
                ObjectNode objectNode = (ObjectNode)node3;
                writer2.writeStartElement(key);
                for (Map.Entry<String, Node> e : objectNode) {
                    this.writeNode(writer2, e.getValue(), e.getKey(), false, currentDepth + 1);
                }
                writer2.writeEndElement();
                break;
            }
            case 3: {
                ArrayNode arrayNode = (ArrayNode)node3;
                if (inArray) {
                    writer2.writeStartElement(key);
                    for (Node e : arrayNode) {
                        this.writeNode(writer2, e, this.options.itemName(), true, currentDepth + 1);
                    }
                    writer2.writeEndElement();
                    break;
                }
                for (Node e : arrayNode) {
                    this.writeNode(writer2, e, key, true, currentDepth + 1);
                }
            }
        }
    }
}

