/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.reflect;

import com.fasterxml.jackson.databind.JavaType;
import cool.scx.reflect.ClassInfo;
import cool.scx.reflect.ConstructorInfo;
import cool.scx.reflect.FieldInfo;
import cool.scx.reflect.MethodInfo;
import cool.scx.reflect.ParameterInfo;
import cool.scx.reflect.ReflectHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.RecordComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

class ClassInfoHelper {
    ClassInfoHelper() {
    }

    static ClassInfo _findSuperClass(ClassInfo classInfo) {
        return classInfo.type().getSuperClass() != null ? ReflectHelper.getClassInfo(classInfo.type().getSuperClass()) : null;
    }

    static ClassInfo[] _findInterfaces(ClassInfo classInfo) {
        List interfaces = classInfo.type().getInterfaces();
        ClassInfo[] result = new ClassInfo[interfaces.size()];
        for (int i = 0; i < interfaces.size(); ++i) {
            result[i] = ReflectHelper.getClassInfo((JavaType)interfaces.get(i));
        }
        return result;
    }

    static boolean _isRecord(ClassInfo classInfo) {
        return classInfo.type().getRawClass().isRecord();
    }

    static boolean _isInterface(ClassInfo classInfo) {
        return classInfo.type().getRawClass().isInterface();
    }

    static boolean _isAbstract(ClassInfo classInfo) {
        return Modifier.isAbstract(classInfo.type().getRawClass().getModifiers());
    }

    static boolean _isEnum(ClassInfo classInfo) {
        return Enum.class.isAssignableFrom(classInfo.type().getRawClass());
    }

    static boolean _isAnonymousClass(ClassInfo classInfo) {
        return classInfo.type().getRawClass().isAnonymousClass();
    }

    static Annotation[] _findAnnotations(ClassInfo classInfo) {
        return classInfo.type().getRawClass().getDeclaredAnnotations();
    }

    static ConstructorInfo[] _findConstructorInfos(ClassInfo classInfo) {
        Constructor<?>[] constructors = classInfo.type().getRawClass().getDeclaredConstructors();
        ConstructorInfo[] result = new ConstructorInfo[constructors.length];
        for (int i = 0; i < constructors.length; ++i) {
            result[i] = new ConstructorInfo(constructors[i], classInfo);
        }
        return result;
    }

    static FieldInfo[] _findFieldInfos(ClassInfo classInfo) {
        Field[] fields = classInfo.type().getRawClass().getDeclaredFields();
        FieldInfo[] result = new FieldInfo[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            result[i] = new FieldInfo(fields[i], classInfo);
        }
        return result;
    }

    static MethodInfo[] _findMethodInfos(ClassInfo classInfo) {
        Method[] methods = classInfo.type().getRawClass().getDeclaredMethods();
        ArrayList<MethodInfo> list = new ArrayList<MethodInfo>();
        for (Method method : methods) {
            if (method.isBridge()) continue;
            list.add(new MethodInfo(method, classInfo));
        }
        return (MethodInfo[])list.toArray(MethodInfo[]::new);
    }

    static Annotation[] _findAllAnnotations(ClassInfo classInfo) {
        ArrayList allAnnotations = new ArrayList();
        while (classInfo != null) {
            Collections.addAll(allAnnotations, classInfo.annotations());
            classInfo = classInfo.superClass();
        }
        return (Annotation[])allAnnotations.toArray(Annotation[]::new);
    }

    static FieldInfo[] _findAllFieldInfos(ClassInfo classInfo) {
        ArrayList allFieldInfos = new ArrayList();
        while (classInfo != null) {
            Collections.addAll(allFieldInfos, classInfo.fields());
            classInfo = classInfo.superClass();
        }
        return (FieldInfo[])allFieldInfos.toArray(FieldInfo[]::new);
    }

    static MethodInfo[] _findAllMethodInfos(ClassInfo classInfo) {
        HashSet<MethodInfo> filter = new HashSet<MethodInfo>();
        ArrayList<MethodInfo> allMethodInfo = new ArrayList<MethodInfo>();
        while (classInfo != null) {
            MethodInfo[] methods;
            for (MethodInfo method : methods = classInfo.methods()) {
                boolean b;
                if (method.superMethod() != null) {
                    filter.add(method.superMethod());
                }
                if (b = filter.contains(method)) continue;
                allMethodInfo.add(method);
            }
            classInfo = classInfo.superClass();
        }
        return (MethodInfo[])allMethodInfo.toArray(MethodInfo[]::new);
    }

    static ConstructorInfo _findNoArgsConstructor(ClassInfo classInfo) {
        for (ConstructorInfo constructor : classInfo.constructors()) {
            if (constructor.parameters().length != 0) continue;
            return constructor;
        }
        return null;
    }

    static ConstructorInfo _findRecordConstructor(ClassInfo classInfo) {
        if (!classInfo.isRecord()) {
            return null;
        }
        JavaType[] recordComponentTypes = ClassInfoHelper._getRecordComponentsTypes(classInfo);
        for (ConstructorInfo constructor : classInfo.constructors()) {
            boolean matched = ClassInfoHelper._hasSameParameterTypes(constructor, recordComponentTypes);
            if (!matched) continue;
            return constructor;
        }
        return null;
    }

    static ClassInfo _findEnumClass(ClassInfo classInfo) {
        if (classInfo.isEnum()) {
            return classInfo.isAnonymousClass() ? classInfo.superClass() : classInfo;
        }
        return null;
    }

    private static JavaType[] _getRecordComponentsTypes(ClassInfo classInfo) {
        RecordComponent[] recordComponents = classInfo.type().getRawClass().getRecordComponents();
        JavaType[] result = new JavaType[recordComponents.length];
        for (int i = 0; i < recordComponents.length; ++i) {
            result[i] = ReflectHelper._findType(recordComponents[i].getGenericType(), classInfo);
        }
        return result;
    }

    private static boolean _hasSameParameterTypes(ConstructorInfo constructorInfo, JavaType[] types) {
        if (constructorInfo.parameters().length != types.length) {
            return false;
        }
        ParameterInfo[] p1 = constructorInfo.parameters();
        for (int i = 0; i < p1.length; ++i) {
            Class p2Type;
            Class p1Type = p1[i].type().getRawClass();
            if (p1Type == (p2Type = types[i].getRawClass())) continue;
            return false;
        }
        return true;
    }
}

