/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.reflect;

import com.fasterxml.jackson.databind.JavaType;
import cool.scx.reflect.AccessModifier;
import cool.scx.reflect.ClassInfo;
import cool.scx.reflect.MethodInfo;
import cool.scx.reflect.ParameterInfo;
import cool.scx.reflect.ReflectHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;

class MethodInfoHelper {
    MethodInfoHelper() {
    }

    static String _findName(MethodInfo methodInfo) {
        return methodInfo.method().getName();
    }

    static boolean _isAbstract(MethodInfo methodInfo) {
        return Modifier.isAbstract(methodInfo.method().getModifiers());
    }

    static boolean _isStatic(MethodInfo methodInfo) {
        return Modifier.isStatic(methodInfo.method().getModifiers());
    }

    static AccessModifier _findAccessModifier(MethodInfo methodInfo) {
        return ReflectHelper._findAccessModifier(methodInfo.method().getModifiers());
    }

    static Annotation[] _findAnnotations(MethodInfo methodInfo) {
        return methodInfo.method().getDeclaredAnnotations();
    }

    static JavaType _findReturnType(MethodInfo methodInfo) {
        return ReflectHelper._findType(methodInfo.method().getGenericReturnType(), methodInfo.classInfo());
    }

    static ParameterInfo[] _findParameterInfos(MethodInfo methodInfo) {
        Parameter[] parameters = methodInfo.method().getParameters();
        ParameterInfo[] result = new ParameterInfo[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            result[i] = new ParameterInfo(parameters[i], methodInfo);
        }
        return result;
    }

    static MethodInfo _findSuperMethod(MethodInfo methodInfo) {
        for (ClassInfo superClass = methodInfo.classInfo().superClass(); superClass != null; superClass = superClass.superClass()) {
            MethodInfo[] superMethods;
            for (MethodInfo superMethod : superMethods = superClass.methods()) {
                boolean b = MethodInfoHelper.isOverride(methodInfo, superMethod);
                if (!b) continue;
                return superMethod;
            }
        }
        return null;
    }

    static Annotation[] _findAllAnnotations(MethodInfo methodInfo) {
        ArrayList allAnnotations = new ArrayList();
        while (methodInfo != null) {
            Collections.addAll(allAnnotations, methodInfo.annotations());
            methodInfo = methodInfo.superMethod();
        }
        return (Annotation[])allAnnotations.toArray(Annotation[]::new);
    }

    private static boolean isOverride(MethodInfo rootMethod, MethodInfo candidateMethod) {
        return AccessModifier.PRIVATE != candidateMethod.accessModifier() && candidateMethod.name().equals(rootMethod.name()) && MethodInfoHelper._hasSameParameterTypes(rootMethod, candidateMethod);
    }

    private static boolean _hasSameParameterTypes(MethodInfo rootMethod, MethodInfo candidateMethod) {
        if (candidateMethod.parameters().length != rootMethod.parameters().length) {
            return false;
        }
        ParameterInfo[] p1 = rootMethod.parameters();
        ParameterInfo[] p2 = candidateMethod.parameters();
        for (int i = 0; i < p1.length; ++i) {
            Class p2Type;
            Class p1Type = p1[i].type().getRawClass();
            if (p1Type == (p2Type = p2[i].type().getRawClass())) continue;
            return false;
        }
        return true;
    }
}

