/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.reflect;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeBindings;
import cool.scx.common.util.ObjectUtils;
import cool.scx.reflect.AccessModifier;
import cool.scx.reflect.ClassInfo;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class ReflectHelper {
    private static final Map<JavaType, ClassInfo> CLASS_INFO_CACHE = new HashMap<JavaType, ClassInfo>();

    public static ClassInfo getClassInfo(Class<?> javaType) {
        return ReflectHelper.getClassInfo(ObjectUtils.constructType(javaType));
    }

    public static ClassInfo getClassInfo(JavaType javaType) {
        ClassInfo classInfo = CLASS_INFO_CACHE.get(javaType);
        if (classInfo == null) {
            classInfo = new ClassInfo(javaType);
            CLASS_INFO_CACHE.put(javaType, classInfo);
        }
        return classInfo;
    }

    static AccessModifier _findAccessModifier(int m) {
        if (Modifier.isPublic(m)) {
            return AccessModifier.PUBLIC;
        }
        if (Modifier.isProtected(m)) {
            return AccessModifier.PROTECTED;
        }
        if (Modifier.isPrivate(m)) {
            return AccessModifier.PRIVATE;
        }
        return AccessModifier.DEFAULT;
    }

    static JavaType _findType(Type type, ClassInfo classInfo) {
        return ObjectUtils.resolveMemberType((Type)type, (TypeBindings)classInfo.type().getBindings());
    }
}

