/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.reflect;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeBindings;
import cool.scx.common.util.ObjectUtils;
import cool.scx.reflect.AccessModifier;
import cool.scx.reflect.ClassInfo;
import cool.scx.reflect.ClassInfoFactory;
import cool.scx.reflect.ClassType;
import cool.scx.reflect.ConstructorInfo;
import cool.scx.reflect.ExecutableInfo;
import cool.scx.reflect.FieldInfo;
import cool.scx.reflect.MethodInfo;
import cool.scx.reflect.MethodType;
import cool.scx.reflect.ParameterInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessFlag;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

final class ReflectHelper {
    ReflectHelper() {
    }

    public static JavaType _findType(Type type, ClassInfo classInfo) {
        return ObjectUtils.resolveMemberType((Type)type, (TypeBindings)classInfo.type().getBindings());
    }

    public static AccessModifier _findAccessModifier(Set<AccessFlag> accessFlags) {
        if (accessFlags.contains((Object)AccessFlag.PUBLIC)) {
            return AccessModifier.PUBLIC;
        }
        if (accessFlags.contains((Object)AccessFlag.PROTECTED)) {
            return AccessModifier.PROTECTED;
        }
        if (accessFlags.contains((Object)AccessFlag.PRIVATE)) {
            return AccessModifier.PRIVATE;
        }
        return AccessModifier.PACKAGE_PRIVATE;
    }

    public static ClassType _findClassType(Class<?> rawClass, Set<AccessFlag> accessFlags) {
        if (accessFlags.contains((Object)AccessFlag.ANNOTATION)) {
            return ClassType.ANNOTATION;
        }
        if (accessFlags.contains((Object)AccessFlag.INTERFACE)) {
            return ClassType.INTERFACE;
        }
        if (accessFlags.contains((Object)AccessFlag.ABSTRACT)) {
            return ClassType.ABSTRACT_CLASS;
        }
        if (accessFlags.contains((Object)AccessFlag.ENUM)) {
            return ClassType.ENUM;
        }
        if (rawClass.isRecord()) {
            return ClassType.RECORD;
        }
        return ClassType.CONCRETE;
    }

    public static MethodType _findMethodType(Method method, Set<AccessFlag> accessFlags) {
        if (accessFlags.contains((Object)AccessFlag.ABSTRACT)) {
            return MethodType.ABSTRACT;
        }
        if (accessFlags.contains((Object)AccessFlag.STATIC)) {
            return MethodType.STATIC;
        }
        if (method.isDefault()) {
            return MethodType.DEFAULT;
        }
        return MethodType.NORMAL;
    }

    public static ClassInfo _findSuperClass(JavaType type) {
        JavaType superClass = type.getSuperClass();
        return superClass != null ? ClassInfoFactory.getClassInfo(superClass) : null;
    }

    public static ClassInfo[] _findInterfaces(JavaType type) {
        List interfaces = type.getInterfaces();
        ClassInfo[] result = new ClassInfo[interfaces.size()];
        for (int i = 0; i < interfaces.size(); ++i) {
            result[i] = ClassInfoFactory.getClassInfo((JavaType)interfaces.get(i));
        }
        return result;
    }

    public static ConstructorInfo[] _findConstructorInfos(ClassInfo classInfo) {
        Constructor<?>[] constructors = classInfo.type().getRawClass().getDeclaredConstructors();
        ConstructorInfo[] result = new ConstructorInfo[constructors.length];
        for (int i = 0; i < constructors.length; ++i) {
            result[i] = new ConstructorInfo(constructors[i], classInfo);
        }
        return result;
    }

    public static ConstructorInfo _findDefaultConstructor(ClassInfo classInfo) {
        for (ConstructorInfo constructor : classInfo.constructors()) {
            if (constructor.parameters().length != 0) continue;
            return constructor;
        }
        return null;
    }

    public static ConstructorInfo _findRecordConstructor(ClassInfo classInfo) {
        if (classInfo.classType() != ClassType.RECORD) {
            return null;
        }
        JavaType[] recordComponentTypes = ReflectHelper._getRecordComponentsTypes(classInfo);
        for (ConstructorInfo constructor : classInfo.constructors()) {
            boolean matched = ReflectHelper._hasSameParameterTypes((ExecutableInfo)constructor, recordComponentTypes);
            if (!matched) continue;
            return constructor;
        }
        return null;
    }

    public static FieldInfo[] _findFieldInfos(ClassInfo classInfo) {
        Field[] fields = classInfo.type().getRawClass().getDeclaredFields();
        FieldInfo[] result = new FieldInfo[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            result[i] = new FieldInfo(fields[i], classInfo);
        }
        return result;
    }

    public static FieldInfo[] _findAllFieldInfos(ClassInfo classInfo) {
        ArrayList allFieldInfos = new ArrayList();
        while (classInfo != null) {
            Collections.addAll(allFieldInfos, classInfo.fields());
            classInfo = classInfo.superClass();
        }
        return (FieldInfo[])allFieldInfos.toArray(FieldInfo[]::new);
    }

    public static MethodInfo[] _findMethodInfos(ClassInfo classInfo) {
        Method[] methods = classInfo.type().getRawClass().getDeclaredMethods();
        ArrayList<MethodInfo> list = new ArrayList<MethodInfo>();
        for (Method method : methods) {
            if (method.isBridge()) continue;
            list.add(new MethodInfo(method, classInfo));
        }
        return (MethodInfo[])list.toArray(MethodInfo[]::new);
    }

    public static MethodInfo[] _findAllMethodInfos(ClassInfo classInfo) {
        HashSet<MethodInfo> filter = new HashSet<MethodInfo>();
        ArrayList<MethodInfo> allMethodInfo = new ArrayList<MethodInfo>();
        while (classInfo != null) {
            MethodInfo[] methods;
            for (MethodInfo method : methods = classInfo.methods()) {
                boolean b;
                if (method.superMethod() != null) {
                    filter.add(method.superMethod());
                }
                if (b = filter.contains(method)) continue;
                allMethodInfo.add(method);
            }
            classInfo = classInfo.superClass();
        }
        return (MethodInfo[])allMethodInfo.toArray(MethodInfo[]::new);
    }

    public static Annotation[] _findAllAnnotations(ClassInfo classInfo) {
        ArrayList allAnnotations = new ArrayList();
        while (classInfo != null) {
            Collections.addAll(allAnnotations, classInfo.annotations());
            classInfo = classInfo.superClass();
        }
        return (Annotation[])allAnnotations.toArray(Annotation[]::new);
    }

    public static ClassInfo _findEnumClass(ClassInfo classInfo) {
        if (classInfo.classType() == ClassType.ENUM) {
            return classInfo.isAnonymousClass() ? classInfo.superClass() : classInfo;
        }
        return null;
    }

    public static ClassInfo _findComponentType(ClassInfo classInfo) {
        if (classInfo.isArray()) {
            return ClassInfoFactory.getClassInfo(classInfo.type().getRawClass().componentType());
        }
        return null;
    }

    private static JavaType[] _getRecordComponentsTypes(ClassInfo classInfo) {
        RecordComponent[] recordComponents = classInfo.type().getRawClass().getRecordComponents();
        JavaType[] result = new JavaType[recordComponents.length];
        for (int i = 0; i < recordComponents.length; ++i) {
            result[i] = ReflectHelper._findType(recordComponents[i].getGenericType(), classInfo);
        }
        return result;
    }

    public static ParameterInfo[] _findParameterInfos(ConstructorInfo constructorInfo) {
        Parameter[] parameters = constructorInfo.constructor().getParameters();
        ParameterInfo[] result = new ParameterInfo[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            result[i] = new ParameterInfo(parameters[i], constructorInfo);
        }
        return result;
    }

    public static ParameterInfo[] _findParameterInfos(MethodInfo methodInfo) {
        Parameter[] parameters = methodInfo.method().getParameters();
        ParameterInfo[] result = new ParameterInfo[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            result[i] = new ParameterInfo(parameters[i], methodInfo);
        }
        return result;
    }

    public static MethodInfo _findSuperMethod(MethodInfo methodInfo) {
        for (ClassInfo superClass = methodInfo.classInfo().superClass(); superClass != null; superClass = superClass.superClass()) {
            MethodInfo[] superMethods;
            for (MethodInfo superMethod : superMethods = superClass.methods()) {
                boolean b = ReflectHelper.isOverride(methodInfo, superMethod);
                if (!b) continue;
                return superMethod;
            }
        }
        return null;
    }

    public static Annotation[] _findAllAnnotations(MethodInfo methodInfo) {
        ArrayList allAnnotations = new ArrayList();
        while (methodInfo != null) {
            Collections.addAll(allAnnotations, methodInfo.annotations());
            methodInfo = methodInfo.superMethod();
        }
        return (Annotation[])allAnnotations.toArray(Annotation[]::new);
    }

    private static boolean isOverride(MethodInfo rootMethod, MethodInfo candidateMethod) {
        return AccessModifier.PRIVATE != candidateMethod.accessModifier() && candidateMethod.name().equals(rootMethod.name()) && ReflectHelper._hasSameParameterTypes((ExecutableInfo)rootMethod, candidateMethod);
    }

    private static boolean _hasSameParameterTypes(ExecutableInfo rootMethod, ExecutableInfo candidateMethod) {
        if (candidateMethod.parameters().length != rootMethod.parameters().length) {
            return false;
        }
        ParameterInfo[] p1 = rootMethod.parameters();
        ParameterInfo[] p2 = candidateMethod.parameters();
        for (int i = 0; i < p1.length; ++i) {
            Class p2Type;
            Class p1Type = p1[i].type().getRawClass();
            if (p1Type == (p2Type = p2[i].type().getRawClass())) continue;
            return false;
        }
        return true;
    }

    private static boolean _hasSameParameterTypes(ExecutableInfo constructorInfo, JavaType[] types) {
        if (constructorInfo.parameters().length != types.length) {
            return false;
        }
        ParameterInfo[] p1 = constructorInfo.parameters();
        for (int i = 0; i < p1.length; ++i) {
            Class p2Type;
            Class p1Type = p1[i].type().getRawClass();
            if (p1Type == (p2Type = types[i].getRawClass())) continue;
            return false;
        }
        return true;
    }
}

