/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.reflect;

import com.fasterxml.jackson.databind.JavaType;
import cool.scx.reflect.AccessModifier;
import cool.scx.reflect.ClassInfo;
import cool.scx.reflect.MemberInfo;
import cool.scx.reflect.ReflectHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

public final class FieldInfo
implements MemberInfo {
    private final Field field;
    private final ClassInfo classInfo;
    private final AccessModifier accessModifier;
    private final String name;
    private final JavaType type;
    private final Annotation[] annotations;

    FieldInfo(Field field, ClassInfo classInfo) {
        this.field = field;
        this.classInfo = classInfo;
        this.accessModifier = ReflectHelper._findAccessModifier(field.accessFlags());
        this.name = field.getName();
        this.type = ReflectHelper._findType(field.getGenericType(), classInfo);
        this.annotations = field.getDeclaredAnnotations();
    }

    public Field field() {
        return this.field;
    }

    public String name() {
        return this.name;
    }

    public JavaType type() {
        return this.type;
    }

    public void set(Object obj, Object value) throws IllegalAccessException {
        this.field.set(obj, value);
    }

    public Object get(Object obj) throws IllegalAccessException {
        return this.field.get(obj);
    }

    @Override
    public ClassInfo classInfo() {
        return this.classInfo;
    }

    @Override
    public AccessModifier accessModifier() {
        return this.accessModifier;
    }

    @Override
    public void setAccessible(boolean flag) {
        this.field.setAccessible(flag);
    }

    @Override
    public Annotation[] annotations() {
        return this.annotations;
    }
}

