/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.reflect;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

public interface AnnotatedElementInfo {
    public Annotation[] annotations();

    default public Annotation[] allAnnotations() {
        return this.annotations();
    }

    default public <T extends Annotation> T findAnnotation(Class<T> annotationClass) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = this.annotations()) {
            if (!annotationClass.isInstance(annotation)) continue;
            return (T)annotation;
        }
        return null;
    }

    default public <T extends Annotation> List<T> findAnnotationList(Class<T> annotationClass) {
        Annotation[] annotations = this.annotations();
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        for (Annotation annotation : annotations) {
            if (!annotationClass.isInstance(annotation)) continue;
            result.add(annotation);
        }
        return result;
    }

    default public <T extends Annotation> T findAnnotationFromAll(Class<T> annotationClass) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = this.allAnnotations()) {
            if (!annotationClass.isInstance(annotation)) continue;
            return (T)annotation;
        }
        return null;
    }

    default public <T extends Annotation> List<T> findAnnotationListFromAll(Class<T> annotationClass) {
        Annotation[] annotations = this.allAnnotations();
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        for (Annotation annotation : annotations) {
            if (!annotationClass.isInstance(annotation)) continue;
            result.add(annotation);
        }
        return result;
    }
}

