/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.reflect;

import com.fasterxml.jackson.databind.JavaType;
import cool.scx.reflect.AccessModifier;
import cool.scx.reflect.ClassInfo;
import cool.scx.reflect.ExecutableInfo;
import cool.scx.reflect.MethodType;
import cool.scx.reflect.ParameterInfo;
import cool.scx.reflect.ReflectHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessFlag;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;

public final class MethodInfo
implements ExecutableInfo {
    private final Method method;
    private final ClassInfo classInfo;
    private final String name;
    private final AccessModifier accessModifier;
    private final MethodType methodType;
    private final JavaType returnType;
    private final ParameterInfo[] parameters;
    private final MethodInfo superMethod;
    private final Annotation[] annotations;
    private final Annotation[] allAnnotations;
    private final boolean isFinal;

    MethodInfo(Method method, ClassInfo classInfo) {
        this.method = method;
        this.classInfo = classInfo;
        this.name = method.getName();
        Set<AccessFlag> accessFlags = method.accessFlags();
        this.accessModifier = ReflectHelper._findAccessModifier(accessFlags);
        this.methodType = ReflectHelper._findMethodType(method, accessFlags);
        this.returnType = ReflectHelper._findType(method.getGenericReturnType(), classInfo);
        this.parameters = ReflectHelper._findParameterInfos(this);
        this.superMethod = ReflectHelper._findSuperMethod(this);
        this.annotations = method.getDeclaredAnnotations();
        this.allAnnotations = ReflectHelper._findAllAnnotations(this);
        this.isFinal = accessFlags.contains((Object)AccessFlag.FINAL);
    }

    public Method method() {
        return this.method;
    }

    public Object invoke(Object obj, Object ... args) throws InvocationTargetException, IllegalAccessException {
        return this.method.invoke(obj, args);
    }

    @Override
    public ClassInfo classInfo() {
        return this.classInfo;
    }

    public String name() {
        return this.name;
    }

    @Override
    public AccessModifier accessModifier() {
        return this.accessModifier;
    }

    public MethodType methodType() {
        return this.methodType;
    }

    public JavaType returnType() {
        return this.returnType;
    }

    @Override
    public ParameterInfo[] parameters() {
        return this.parameters;
    }

    public MethodInfo superMethod() {
        return this.superMethod;
    }

    @Override
    public Annotation[] annotations() {
        return this.annotations;
    }

    @Override
    public Annotation[] allAnnotations() {
        return this.allAnnotations;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    @Override
    public void setAccessible(boolean flag) {
        this.method.setAccessible(flag);
    }
}

