/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.reflect;

import com.fasterxml.jackson.databind.JavaType;
import cool.scx.reflect.AccessModifier;
import cool.scx.reflect.AnnotatedElementInfo;
import cool.scx.reflect.ClassType;
import cool.scx.reflect.ConstructorInfo;
import cool.scx.reflect.FieldInfo;
import cool.scx.reflect.MethodInfo;
import cool.scx.reflect.ReflectHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessFlag;
import java.util.Set;

public final class ClassInfo
implements AnnotatedElementInfo {
    private final JavaType type;
    private final String name;
    private final AccessModifier accessModifier;
    private final ClassType classType;
    private final ClassInfo superClass;
    private final ClassInfo[] interfaces;
    private final ConstructorInfo[] constructors;
    private final ConstructorInfo defaultConstructor;
    private final ConstructorInfo recordConstructor;
    private final FieldInfo[] fields;
    private final FieldInfo[] allFields;
    private final MethodInfo[] methods;
    private final MethodInfo[] allMethods;
    private final Annotation[] annotations;
    private final Annotation[] allAnnotations;
    private final boolean isFinal;
    private final boolean isStatic;
    private final boolean isAnonymousClass;
    private final boolean isMemberClass;
    private final boolean isPrimitive;
    private final boolean isArray;
    private final ClassInfo enumClass;
    private final ClassInfo componentType;

    ClassInfo(JavaType type) {
        this.type = type;
        Class rawClass = type.getRawClass();
        this.name = rawClass.getName();
        Set<AccessFlag> accessFlags = rawClass.accessFlags();
        this.accessModifier = ReflectHelper._findAccessModifier(accessFlags);
        this.classType = ReflectHelper._findClassType(rawClass, accessFlags);
        this.superClass = ReflectHelper._findSuperClass(type);
        this.interfaces = ReflectHelper._findInterfaces(type);
        this.constructors = ReflectHelper._findConstructorInfos(this);
        this.defaultConstructor = ReflectHelper._findDefaultConstructor(this);
        this.recordConstructor = ReflectHelper._findRecordConstructor(this);
        this.fields = ReflectHelper._findFieldInfos(this);
        this.allFields = ReflectHelper._findAllFieldInfos(this);
        this.methods = ReflectHelper._findMethodInfos(this);
        this.allMethods = ReflectHelper._findAllMethodInfos(this);
        this.annotations = rawClass.getDeclaredAnnotations();
        this.allAnnotations = ReflectHelper._findAllAnnotations(this);
        this.isFinal = accessFlags.contains((Object)AccessFlag.FINAL);
        this.isStatic = accessFlags.contains((Object)AccessFlag.STATIC);
        this.isAnonymousClass = rawClass.isAnonymousClass();
        this.isMemberClass = rawClass.isMemberClass();
        this.isPrimitive = rawClass.isPrimitive();
        this.isArray = rawClass.isArray();
        this.enumClass = ReflectHelper._findEnumClass(this);
        this.componentType = ReflectHelper._findComponentType(this);
    }

    public JavaType type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public AccessModifier accessModifier() {
        return this.accessModifier;
    }

    public ClassType classType() {
        return this.classType;
    }

    public ClassInfo superClass() {
        return this.superClass;
    }

    public ClassInfo[] interfaces() {
        return this.interfaces;
    }

    public ConstructorInfo[] constructors() {
        return this.constructors;
    }

    public ConstructorInfo defaultConstructor() {
        return this.defaultConstructor;
    }

    public ConstructorInfo recordConstructor() {
        return this.recordConstructor;
    }

    public FieldInfo[] fields() {
        return this.fields;
    }

    public FieldInfo[] allFields() {
        return this.allFields;
    }

    public MethodInfo[] methods() {
        return this.methods;
    }

    public MethodInfo[] allMethods() {
        return this.allMethods;
    }

    @Override
    public Annotation[] annotations() {
        return this.annotations;
    }

    @Override
    public Annotation[] allAnnotations() {
        return this.allAnnotations;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isAnonymousClass() {
        return this.isAnonymousClass;
    }

    public boolean isMemberClass() {
        return this.isMemberClass;
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public ClassInfo enumClass() {
        return this.enumClass;
    }

    public ClassInfo componentType() {
        return this.componentType;
    }

    public ClassInfo findSuperType(Class<?> rawTarget) {
        if (rawTarget == this.type.getRawClass()) {
            return this;
        }
        if (rawTarget.isInterface()) {
            for (ClassInfo anInterface : this.interfaces) {
                ClassInfo type = anInterface.findSuperType(rawTarget);
                if (type == null) continue;
                return type;
            }
        }
        if (this.superClass != null) {
            return this.superClass.findSuperType(rawTarget);
        }
        return null;
    }
}

